/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetProductVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 17:35
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import java.util.List;

/**
 * 拼团失败退款
 *
 * @author shichang.wang 2021/4/15
 */
@ApiModel("拼团失败退款")
@Data
public class SpellGroupFailRefundVo {


    @NotEmpty(message = "团号不能为空")
    @ApiModelProperty("团号")
    private String spellGroupCode;


    /**
     * 原因
     */
    @ApiModelProperty("原因")
    private String reason;

    /**
     * 物流单号
     */
    @NotEmpty(message = "订单号列表 不能为空")
    @ApiModelProperty("订单号列表")
    private List<String> orderCodeList;



}
