package cn.freemud.management.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.adapter.SaasMallOrderAdapter;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.order.OrderManagerResponse;
import cn.freemud.management.entities.dto.response.pay.PayRefundResponse;
import cn.freemud.management.enums.OperateType;
import cn.freemud.management.intercept.OrderServiceException;
import cn.freemud.management.service.OrderBaseService;
import cn.freemud.management.service.OrderManagerService;
import cn.freemud.management.service.handle.*;
import cn.freemud.management.util.ResponseUtil;
import com.freemud.application.sdk.api.ordercenter.enums.AfterSalesStatus;
import com.freemud.sdk.api.assortment.order.enums.PayRefundStatus;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import com.netflix.discovery.converters.Auto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: rrr
 * @Package cn.freemud.management.service.impl
 * @Description: 外卖订单履单操作
 * @author: zhiheng.zhang
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class MallOrderMangerServiceImpl implements OrderManagerService {
    @Autowired
    private MallOrderHandle mallOrderHandle;
    @Autowired
    private OrderBaseService orderBaseService;
    @Autowired
    private PaymentHandle paymentHandle;
    @Autowired
    private DeliveryHandle deliveryHandle;
    @Autowired
    private StockHandle stockHandle;

    /**
     * 同意退款
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderAgreeRefund(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        //取消配送单
//        deliveryHandle.cancelDelivery(orderBean,request);
        if(Objects.nonNull(orderBean.getAfterSalesOrderResp()) && Objects.equals(AfterSalesStatus.PENDING.getIndex(), orderBean.getAfterSalesOrderResp().getAfterSalesStatus())){
            // 修改售后单状态为退货中
            mallOrderHandle.mallOrderAgreeApply(request, orderBean);
        }else {
            //支付退款
            PayRefundResponse refundResponse = new PayRefundResponse();
            try {
                refundResponse = paymentHandle.refund(request, orderBean);
            } catch (OrderServiceException orderEx) {
                return ResponseUtil.error(orderEx.getResult());
            }
//        refundResponse.setPayRefundStatus(PayRefundStatus.SUCCESS);
            //订单同意退款
            mallOrderHandle.refundAgree(request, refundResponse, orderBean);
            // 推送pos、微信消息中心
            orderBaseService.sendMessage(orderBean, OperateType.ORDER_AGREE_REFUND, request.getReason());
            //todo  可以考虑基于订单回调异步实现
            //冲正库存
            stockHandle.revert(request, orderBean);
        }
        return ResponseUtil.success();
    }

    /**
     * 拒绝退款
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderRejectRefund(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        //拒绝退款
        mallOrderHandle.refundReject(request,orderBean);
        // 推送pos、微信消息中心
        orderBaseService.sendMessage(orderBean, OperateType.ORDER_REJECT_REFUND, request.getReason());
        return ResponseUtil.success();
    }

}
