package cn.freemud.entities.dto.promotion;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author freemud
 * @title: QueryHistorygroupVO
 * @projectName order-group
 * @description: TODO
 * @date 2021/4/28下午2:45
 */
@Data
public class QueryHistoryGroupVO { //活动号
    private String activeId;
    //活动名称
    private String activeName;
    //开始时间
    private String startTime;
    //活动结束时间
    private String endTime;
    //团状态：0-组团中，1-已成团，2-成团失败
    private Integer groupStatus;
    //开团结束时间
    private String groupEndTime;
    //几人成团
    private Integer peopleLimit;
    //当前用户是否已参与：0-否，1-是
    private Integer isJoin;
    //订单号
    private String orderId;
    //参团信息集合
    private List<Participants> participants;
    //商品
    private Good good;
    //团信息
    private Group group;

    @Data
    public static class Participants {
        @ApiModelProperty(value = "是否团长：0不是，1-是", name = "sponsor", example = "1")
        private Integer sponsor;
        @ApiModelProperty(value = "团号", name = "groupId", example = "123")
        private String groupId;
        @ApiModelProperty(value = "用户昵称", name = "headUrl", example = "123")
        private String userName;
        @ApiModelProperty(value = "头像", name = "headUrl", example = "2")
        private String headUrl;
        @ApiModelProperty(value = "参团人数", name = "joinPeople", example = "2")
        private String orderId;
    }

    @Data
    public static class Good {
        @ApiModelProperty(value = "商品id", name = "groupStatus", example = "1")
        private String goodId;
        @ApiModelProperty(value = "商品名称", name = "goodName", example = "2")
        private String goodName;
        @ApiModelProperty(value = "拼团价，单位分", name = "price", example = "2021-04-21 23:59:59")
        private Integer price;
        @ApiModelProperty(value = "商品原价，单位分", name = "originPrice", example = "2")
        private Integer originPrice;
    }

    @Data
    public static class Group {
        @ApiModelProperty(value = "团号", name = "groupId", example = "1")
        private String groupId;
        @ApiModelProperty(value = "活动号", name = "groupId", example = "1")
        private String activeId;
        @ApiModelProperty(value = "团状态：0-组团中，1-已成团，2-成团失败", name = "groupStatus", example = "1")
        private Integer groupStatus;
        @ApiModelProperty(value = "开团开始时间", name = "startTime", example = "2021-04-15 00:00:00")
        private String startTime;
        @ApiModelProperty(value = "开团结束时间", name = "endTime", example = "2021-04-21 23:59:59")
        private String endTime;
        @ApiModelProperty(value = "差多少人成团", name = "lessPeople", example = "2")
        private Integer lessPeople;
        @ApiModelProperty(value = "已参团人数", name = "count", example = "2")
        private Integer count;
        @ApiModelProperty(value = "成团时间", name = "groupTime", example = "2021-04-15 00:00:00")
        private String groupTime;
        @ApiModelProperty(value = "剩余时间戳毫秒", name = "groupTime", example = "2021-04-15 00:00:00")
        private Long time;
    }
}
