package cn.freemud.entities.vo.coupon;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By sunary.site
 *
 * @version v1.0
 * @Title: IntelliJ IDEA
 * @Package cn.freemud.service.impl.mcoffee.entity
 * @Description: 请简单描述下这个类是做什么用的
 * @author: yu.sun
 * @date: 2020-10-26 13:59:32
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 */
@Data
public class CouponAvailableCartInfo {
    //渠道id
    private String providerId;
    //商户号
    private String merchantId;
    //门店id（校验门店限制）
    private String storeId;
    //组织机构id列表（校验渠道限制）
    private List<String> channelIdList;
    //组织机构code列表（校验渠道限制）
    private List<String> channelCodeList;
    //已使用券列表
    private List<String> couponCodes;
    /**
     * 总原价金额(包括主商品+可选搭配+加料商品)
     */
    private Long originalTotalAmount;
    /**
     * 总实付金额(包括主商品+可选搭配+加料商品)
     */
    private Long realAmount;

    //总优惠金额(不包括赠品优惠金额和套餐优惠金额)
    private Long discountAmount;

    //购物车商品列表
    private List<CartProduct> productList;

    //由于老的算价接口优惠券和活动直接就是互斥的,因此不需要依赖券里面的配置
    private  boolean exclusion = false;
    /**
     * 配送费
     */
    private Long deliveryAmount;

    /**
     * 优惠后 配送费
     */
    private Long distributionFee;
}
