package cn.freemud.amp.service;

import cn.freemud.amqp.Header;
import cn.freemud.amqp.MQAction;
import cn.freemud.amqp.MQMessage;
import cn.freemud.entities.dto.delivery.CallbackUrlRequestDto;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Random;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
@ActiveProfiles("dev")
@Slf4j
public class ProduceMQServiceTest {

    @Autowired
    private ProduceMQService produceMQService;

    @Test
    public void sendOfDeliveryInfo() {
        CallbackUrlRequestDto callbackUrlRequestDto = buildCallbackUrlRequestDto();
        produceMQService.sendOfDeliveryInfo(callbackUrlRequestDto);
    }

    @Test
    public void send() {
        CallbackUrlRequestDto callbackUrlRequestDto = buildCallbackUrlRequestDto();
        produceMQService.sendRocketMqOfDeliveryInfo(callbackUrlRequestDto);
    }

    public MQMessage buildMQMessage() {
        MQMessage body = new MQMessage();

        Header header = new Header(MQAction.UPDATE.getAction(), "order-application-service", "orderId", "ORDER_DELIVERY");
        body.setHeader(header);
        CallbackUrlRequestDto callbackUrlRequestDto = buildCallbackUrlRequestDto();
        Random random = new Random(System.currentTimeMillis());
        callbackUrlRequestDto.setDeliveryStatus(random.nextInt(8) + 1);

        body.setBody(callbackUrlRequestDto);
        return body;
    }

    public CallbackUrlRequestDto buildCallbackUrlRequestDto() {
        String json = "{\n" +
                "    \"channelCode\":\"MeiTuan\",\n" +
                "    \"channelDeliveryId\":\"1584868781086019780\",\n" +
                "    \"channelName\":\"美团\",\n" +
                "    \"deliveryId\":\"6913353047542579209b\",\n" +
                "    \"deliveryStatus\":2,\n" +
                "    \"orderId\":\"17283381807564801000006\",\n" +
                "    \"partnerId\":\"1864\",\n" +
                "    \"riderName\":\"宋**\",\n" +
                "    \"riderPhone\":\"1782****316\",\n" +
                "    \"storeId\":\"a785e270-0f67-4805-b3db-6e2604b87909\",\n" +
                "    \"updateTime\":\"2020-03-22 17:20:45\"\n" +
                "}";

        CallbackUrlRequestDto callbackUrlRequestDto = JSON.parseObject(json, CallbackUrlRequestDto.class);
        return callbackUrlRequestDto;
    }

    public static void main(String args[]){
        System.out.println();
    }
}
