/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title:
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/23 10:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.awt.geom.Point2D;
import java.util.List;

@NoArgsConstructor
@Data
public class ShoppingCartInfoDto {

    private List<ProductBean> data;
    /**
     * 起送费
     */
    private Long deliveryLimitAmount;
    /**
     * 配送费
     */
    private Long deliveryAmount;
    /**
     * 总包装费
     */
    private Long packAmount;
    /**
     * 门店是否可配送
     */
    private Boolean enableTakeaway;
    /**
     * 门店配送时间
     */
    private String deliveryHoursDay;
    /**
     * 门店配送范围集合
     */
    private List<Point2D.Double> point2DList;
    /**
     * 配送范围绘制{1：自定义；2：按半径},默认为1
     */
    private String scopeConfig;
    /**
     * 配送半径,整型，单位米
     */
    private Integer deliveryRadius;
    /**
     * 门店经度
     */
    private String longitude;
    /**
     * 门店维度
     */
    private String latitude;
    /**
     * 商品总价格
     */
    private Long amount;
    /**
     * 商品原总价格
     */
    private Long originalAmount;
    /**
     * 是否有商品折扣变动
     */
    private Boolean discountChange = false;
    /**
     * 折扣变动信息
     */
    private String discountChangeMessage;
    /**
     * 活动id
     */
    private String activityId;
    /**
     * 活动名称
     */
    private String activityName;

    private Integer code;
    private String message;

    @NoArgsConstructor
    @Data
    public static class ProductBean {

        @JsonProperty("cart_item_id")
        private String cartProductId;
        /**
         * spuId
         */
        private String id;

        private Integer qty;
        //商品类型
        private Integer type;
        /**
         *  sku Id
         */
        @JsonProperty("spec_id")
        private String specId;

        private String name;

        private String skuName;

        private Long finalPrice;

        private Long originalPrice;

        private Long packPrice;

        private String picture;

        /**
         * 商品折扣信息
         */
        private CartAddItem.DiscountMessage discountMessage;

        @JsonProperty("add_extra")
        private List<ExtraProductDto> addExtra;

        @NoArgsConstructor
        @Data
        public static class ExtraProductDto {

            private String id;

            private Integer qty;

            @JsonProperty("group_id")
            private String groupId;

            private String productName;

            private long finalPrice;

            private long originalPrice;

        }

    }
}
