/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponService
 * @Package cn.freemud.service
 * @Description:
 * @author: song.cai
 * @date: 2018/12/24 18:39
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service;

import cn.freemud.entities.dto.*;
import cn.freemud.entities.vo.*;

import java.util.List;
import java.util.Map;

public interface CouponService {


    /**
     * 获取卡券详情
     *
     * @param requestVo
     * @return
     */
    GetCouponDetailResponseDto getMemberCoupon(GetMemberCouponRequestVo requestVo);

    List<GetMemberCouponListResponseDto.Result.MemberCoupon> getValidMemberCouponList(GetMemberCouponListRequestDto getMemberCouponListRequestDto, Integer orderType);

    /**
     * 调用会员接口列表
     *
     * @param cartGoods
     * @return
     */
    ActivityClassifyCouponBean availableCoupon(List<CartGoods> cartGoods, String partnerId, String userId, String storeId, CouponPromotionVO couponPromotionVO, boolean hasGoodsCoupon, Integer orderType, int isNew,String appId,String MenuType, String unChooseCouponCode);

    /**
     * 获取卡券服务商户密钥
     */
    String getAppSecret(String partnerId);


    CheckSpqInfoResponseDto checkSpqInfo(CheckSpqInfoRequestDto requestDto, String goodsId);

    GetProductsVo getSpqProductInfo(CheckSpqInfoRequestDto requestDto);


    GetProductsVo getSpqProductInfo(CheckSpqInfoRequestDto requestDto, String goodsId);


    GetCouponBarCodeResponseVo getCouponBarCode(String couponCode);

    /**
     *
     * @param partnerId
     * @param activityCodes
     * @param orderTye
     * 返回 key = 活动code， value=  返回是否匹配点餐方式
     */
    Map<String, Boolean> couponOrderWay(String partnerId, List<String> activityCodes, Integer orderTye);

}
