/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: PromotionActivityClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/6 11:14
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(name = "PROMOTION-ACTIVITIES", url = "${saas.promotionactivityclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface PromotionActivityClient {


    /**
     * 增加分享裂变活动的分享记录
     */
    @LogIgnoreFeign(logMessage="shareRecord")
    @PostMapping("/activities/share/record")
    BaseResponse shareRecord(@RequestBody ShareAcitivityRequestDto createActivityRecordDto);


    /**
     * 根据活动ID查询活动信息
     */
    @LogIgnoreFeign(logMessage="getActivity")
    @GetMapping("/activities/share/getActivity")
    ActivityGetByIdResponseDto getById(@RequestParam("activityId") Long activityId);


    /**
     * 获取活动id
     */
    @LogIgnoreFeign(logMessage="queryValidShareActivity")
    @PostMapping("/activities/share/queryValidShareActivity")
    BaseResponse queryValidShareActivity(@RequestBody QueryValidShareActivityReq activityReq);

}
