/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderProductAddInfoDto
 * @Package com.freemud.sdk.api.assortment.request.order
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/9 17:25
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import com.freemud.sdk.api.assortment.order.vo.ProductGroupVo;
import lombok.Data;

import java.util.List;

@Data
public class OrderProductAddInfoDto extends BaseConfig {
    /**
     * 库存模式,目前该模式只针对套餐商品会起作用
     * 1-使用套餐库存(非关联模式)：即套餐库存和套餐中子商品品库存分别存在、互不影响
     * 2-使用联动库存(关联模式)：即套餐商品的库存为套餐库存和套餐中子商品的库存，当用户购买套餐商品时，同时扣减套餐库存和套餐中子商品的库存，当套餐中任一子商品库存为0或套餐商品的库存为0时，该套餐将不能购买
     */
    protected Integer stockMode = 1;

    /**
     *  是否扣库存
     */
    protected boolean stockLimit;
    /**
     * 属性名称 多糖/冷/常温
     */
    private String attributeNames;

    /**
     * 属性英文名称 多糖/冷/常温
     */
    private String attributeForeignNames;

    /**
     * 是否是套餐内固定商品
     */
    private Boolean isFixedProduct;

    /**
     * 第三方商品规格ID
     */
    private String thirdProductSpecId;

    /**
     * 第三方商品属性ID
     */
    private String thirdProductPropertyId;

    /**
     * 第三方品类id
     */
    private String thirdCategoryId;

    /** 商品组 **/
    private List<ProductGroupVo> productGroupList;

    /** 是否主食 **/
    private Integer stapleFood;

    /**
     * 商品绑定的券活动（买券虚拟订单才有）
     */
    private List<ProductBindingCouponType> productBindingCoupons;

    /**
     * 商品统计分类编号
     */
    private String thirdCensusCategoryId;

    /**
     * 商品统计分类名称
     */
    private String thirdCensusCategoryName;

    private double tax;

    private String taxId;

    private List<OrderSpecialExtraAttrRequest> specialAttrs;

    /**
     * 购物车行uid
     */
    private String cartGoodsUid;

    /**
     * 拼单买一赠一标记赠品是那个商品送的 originalGoodsUid
     */
    private String originalGoodsUid;

    /**
     * 是否需要积分
     */
    private Boolean needBonus;
    /**
     * 拆分前所属序列
     */
    private String splitIndex;

    private Long productGroupId;

    /**
     * 虚拟商品发券id
     */
    private String cardId;

    /**
     * 虚拟商品种子券号
     */
    private String cardCode;
    /**
     * 是否是月享卡商品
     */
    private Integer isMonthCard = 0;
    /**
     * 是否是买3赠1券商品
     */
    private Integer isB3S1Coupon = 0;

    /**
     * 是否赠品
     */
    private Boolean isSendGoods;

    //积分商品活动使用总积分
    private Long score;

    //多规格商品的spu商品　商品货号，单规格即为单规格商品货号
    private String spuProductCode;

    /**
     *  【订C，“POS编码”让凌顶那边去匹配商品】 https://www.tapd.cn/43862731/prong/stories/view/1143862731001039549
     */
    private String linkedId;
}
