package com.freemud.application.sdk.api.ordercenter.response;

import lombok.Builder;
import lombok.Data;

import java.util.Date;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/4/26 下午9:04
 * @description :
 * ref_date	string	Y	日期，unix时间戳，字段长度为13字节
 *
 * give_order_amount_sum	float	Y	该日期的下单金额之和
 * give_order_num_sum	integer	Y	该日期的下单数量之和
 * payment_amount_sum	float	Y	该日期的支付金额之和
 * payed_num_sum	integer	Y	该日期的支付数量之和
 */
@Data
@Builder
public class OrderCountResp {

    // 商户号 用于内存剔除 不需要的商户号统计
    private String partnerId;

    // 日期，unix时间戳，字段长度为13字节
    private Date ref_date;

    // 该日期的下单金额之和
    private Float give_order_amount_sum;

    // 该日期的下单数量之和
    private Integer give_order_num_sum;

    // 该日期的支付金额之和
    private Float payment_amount_sum;

    // 该日期的支付数量之和
    private Integer payed_num_sum;

}
