package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: RegisterByMobileVo
 * @Package cn.freemud.entities.vo
 * @Description: 通过手机号码注册入参
 * @author: zhenghuan.yang
 * @date: 2018/6/8 11:46
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class RegisterByMobileVo {

    @NotEmpty(message = "sessionId不能为空")
    private String sessionId;

    @NotEmpty(message = "手机号码不能为空")
    private String mobile;

    @NotEmpty(message = "验证码不能为空")
    private String smsCode;
}
