package cn.freemud.entities.dto.calculate;

import lombok.Data;

import java.util.List;

@Data
public class SmallMaterial {

    /**
     * 商品ID
     */
    private String goodsId;
    /**
     * 商品数量
     */
    private Integer goodsQuantity;
    /**
     * 商品原价
     */
    private Integer originalPrice;

    /**
     * 商品现价(单位：分)
     */
    private Integer nowPrice;

    /**
     * 购物车商品行id  购物车用于区分两个一样的goodsId   计算后原样返回给购物车
     */
    private String cartGoodsUid;

    //1，小料；2，可选搭配
    private Integer type;
    /**
     * 总优惠金额
     */
    private Integer discountAmount;

    /**
     * 实付金额
     */
    private Integer realAmount;

    private List<GoodsDiscount> discounts;

}
