//package cn.freemud.client;
//
//import cn.freemud.base.constant.Version;
//import cn.freemud.base.util.DateUtil;
//import cn.freemud.entities.dto.*;
//import cn.freemud.service.thirdparty.CouponClient;
//import cn.freemud.service.thirdparty.CouponOfflineClient;
//import com.alibaba.fastjson.JSON;
//import org.junit.Test;
//import org.junit.runner.RunWith;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
//import org.springframework.boot.test.context.SpringBootTest;
//import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
//import org.springframework.cloud.openfeign.EnableFeignClients;
//import org.springframework.test.context.junit4.SpringRunner;
//
//import java.util.*;
//import java.util.function.Predicate;
//import java.util.stream.Collectors;
////@RunWith(SpringRunner.class)
//@SpringBootTest
//@EnableDiscoveryClient
//@EnableFeignClients
//@EnableAutoConfiguration
//public class CouponClientTest {
//    @Autowired
//    private CouponClient couponClient;
//
//    @Autowired
//    private CouponOfflineClient couponOfflineClient;
//
//    /**
//     * {
//     *   "codes": [
//     *     "88600017956721290413"
//     *   ],
//     *   "orderId": "126265728740503330",
//     *   "partnerCode": "1864",
//     *   "storeId": "1014",
//     *   "userId": "115381881188636164",
//     *   "ver": 1
//     * }
//     */
//    @Test
//    public void create () {
//        CouponCreateDto couponCreateDto = new CouponCreateDto();
//        couponCreateDto.setVer(Version.VERSION_1);
//        couponCreateDto.setUserId("115381881188636164");
//        // 4933
//        couponCreateDto.setActivityCodes(Arrays.asList("5016"));
//        couponCreateDto.setPartnerCode("1864");
//        couponCreateDto.setMobile("15754070662");
//        System.out.println(JSON.toJSON(couponCreateDto));
//        CouponBaseResponseDto responseDto = couponClient.create(couponCreateDto);
//        System.out.println(JSON.toJSON(responseDto));
//    }
//
//    @Test
//    public void list() {
//        CouponListDto couponListDto = new CouponListDto();
//        couponListDto.setPartnerCode("1809");
//        couponListDto.setUserId("12333");
//        couponListDto.setVer(Version.VERSION_1);
//        // 优惠券类型，0：满减券 1：代金券
//        couponListDto.setType(1);
//
//        System.out.println(JSON.toJSON(couponListDto));
//        CouponListResponseDto couponListResponseDto = couponClient.list(couponListDto);
//        System.out.println(JSON.toJSON(couponListResponseDto));
//
//
//        List<CouponListResponseDto.CouponBean> filterList = couponListResponseDto.getResult().stream().filter(a -> Arrays.stream(a.getStoreId().split(",")).anyMatch(Predicate.isEqual("000100"))).collect(Collectors.toList());
//
//        Map<String, CouponListResponseDto.CouponBean> couponBeanMap = filterList.stream().collect(Collectors.toMap(CouponListResponseDto.CouponBean::getCouponCode, a -> a,(k1, k2)->k1));
//        System.out.println(couponBeanMap);
//
//    }
//
//    @Test
//    public void verification() {
//        CouponVerificationDto couponVerificationDto = new CouponVerificationDto();
//        couponVerificationDto.setVer(Version.VERSION_1);
//        couponVerificationDto.setUserId("115381146196928724");
//        couponVerificationDto.setStoreId("1014");
//        couponVerificationDto.setPartnerCode("1864");
//        // 126065756376018730
//        couponVerificationDto.setOrderId("126082012916363042");
//        // 108077749714629
//        couponVerificationDto.setCodes(Arrays.asList("108075569721930"));
//        System.out.println(JSON.toJSON(couponVerificationDto));
//        CouponBaseResponseDto couponBaseResponseDto = couponClient.verification(couponVerificationDto);
//        System.out.println(JSON.toJSON(couponBaseResponseDto));
//    }
//
//    @Test
//    public void checkTest() {
//        VerifyCheckRequestDto verifyCheckRequestDto = new VerifyCheckRequestDto();
//        verifyCheckRequestDto.setCouponCodes(Arrays.asList("88600017956864226138"));
//        verifyCheckRequestDto.setPartnerCode("1864");
//        verifyCheckRequestDto.setUserId("1");
//        verifyCheckRequestDto.setVer(Integer.valueOf(Version.VERSION_1));
//        System.out.println(JSON.toJSONString(verifyCheckRequestDto));
//        CouponBaseResponseDto couponBaseResponseDto = couponClient.verifyCheck(verifyCheckRequestDto);
//        System.out.println(JSON.toJSONString(couponBaseResponseDto));
//    }
//
//    @Test
//    public void noticeTest() {
//        VerifyNoticeRequestDto verifyNoticeRequestDto = new VerifyNoticeRequestDto();
//        verifyNoticeRequestDto.setVer(Integer.valueOf(Version.VERSION_1));
//        verifyNoticeRequestDto.setCouponCode("88600017956864226138");
//        verifyNoticeRequestDto.setOrderId("1");
//        verifyNoticeRequestDto.setPartnerCode("1864");
//        verifyNoticeRequestDto.setStoreId("1002");
//        verifyNoticeRequestDto.setUserId("1");
//        System.out.println(JSON.toJSONString(verifyNoticeRequestDto));
//        CouponBaseResponseDto couponBaseResponseDto = couponClient.verifyNotice(verifyNoticeRequestDto);
//        System.out.println(JSON.toJSONString(couponBaseResponseDto));
//    }
//
//    @Test
//    public void verificationTest() {
//        CouponCodeVerificationDto couponCodeVerificationDto = new CouponCodeVerificationDto();
//        couponCodeVerificationDto.setVer(Integer.valueOf(Version.VERSION_1));
//        couponCodeVerificationDto.setReqtype(71);
//        couponCodeVerificationDto.setPartnerId("1864");
//        couponCodeVerificationDto.setStation_id("-1");
//        couponCodeVerificationDto.setOperator_id("-1");
//        couponCodeVerificationDto.setStore_id("1002");
//        // 订单号
//        couponCodeVerificationDto.setTrans_id("2");
//        couponCodeVerificationDto.setBusiness_date(DateUtil.convert2Str(new Date(), DateUtil.FORMAT_yyyyMMdd));
//        List<CouponCodeVerificationTransDto> transactions = new ArrayList<>();
//        CouponCodeVerificationTransDto couponCodeVerificationTransDto = new CouponCodeVerificationTransDto();
//        couponCodeVerificationTransDto.setCode("88600017956864226138");
//        transactions.add(couponCodeVerificationTransDto);
////        List<CouponCodeVerificationProductDto> products = new ArrayList<>();
////        CouponCodeVerificationProductDto couponCodeVerificationProductDto = new CouponCodeVerificationProductDto();
////        products.add(couponCodeVerificationProductDto);
////        couponCodeVerificationTransDto.setProducts(products);
//        couponCodeVerificationDto.setTransactions(transactions);
//
//        System.out.println(JSON.toJSONString(couponCodeVerificationDto));
//        CouponCodeResponseDto couponCodeResponseDto = couponOfflineClient.verification(couponCodeVerificationDto);
//        System.out.println(couponCodeResponseDto);
//    }
//
//}
