package cn.freemud.management.thirdparty;

import cn.freemud.management.constant.ResponseCodeConstant;
import cn.freemud.management.constant.ResponseCodeKeyConstant;
import cn.freemud.management.entities.dto.request.order.MCCafeCouponLockRequest;
import cn.freemud.management.entities.dto.request.order.MCCafeCouponRequest;
import cn.freemud.management.entities.dto.response.coupon.McdNetBatchQueryResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponBaseResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponQueryResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "OPEN-STORE-COUPON-ADAPTER-SERVICE", url = "${saas.couponadapterclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CouponOfflineMCCafeClient {

    @PostMapping("/mccafe/redeem")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},
            statusCodeFieldName = ResponseCodeKeyConstant.STATUS_CODE,
            printInfoLog = true)
    CouponRedeemResponse redeem(MCCafeCouponRequest mcCafeCouponRequest);

    @PostMapping("/mccafe/cancelRedeem")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},
            statusCodeFieldName = ResponseCodeKeyConstant.STATUS_CODE,
            printInfoLog = true)
    CouponRedeemResponse cancelRedeem(MCCafeCouponRequest mcCafeCouponRequest);

    @PostMapping("/mccafe/query")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},
            statusCodeFieldName = ResponseCodeKeyConstant.STATUS_CODE,
            printInfoLog = true)
    CouponQueryResponse query(MCCafeCouponRequest mcCafeCouponRequest);

    @PostMapping("/mccafe/batchQuery")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},
            statusCodeFieldName = ResponseCodeKeyConstant.STATUS_CODE,
            printInfoLog = true)
    McdNetBatchQueryResponse batchQuery(MCCafeCouponRequest mcCafeCouponRequest);

    @PostMapping("/mccafe/lock")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},
            statusCodeFieldName = ResponseCodeKeyConstant.STATUS_CODE,
            printInfoLog = true)
    CouponBaseResponse lock(MCCafeCouponLockRequest MCCafeCouponLockRequest);

    @PostMapping("/mccafe/unlock")
    @LogIgnoreFeign(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},
            statusCodeFieldName = ResponseCodeKeyConstant.STATUS_CODE,
            printInfoLog = true)
    CouponBaseResponse unlock(MCCafeCouponLockRequest MCCafeCouponLockRequest);
}
