package cn.freemud.service.thirdparty;

import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.MCCafeDeliveryBaseResponse;
import cn.freemud.entities.dto.delivery.*;
import cn.freemud.entities.dto.delivery.QueryDeliveryAmountRequestDto;
import cn.freemud.entities.dto.delivery.QueryDeliveryAmountResponseDto;
import cn.freemud.entities.vo.CreateDeliveryVo;
import com.freemud.application.sdk.api.deliverycenter.response.CreateDeliveryOrderResponseDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = "DELIVERYCENTER", url = "${delivery.center.feignUrl}")
public interface DeliveryFeiginClient {

    @PostMapping("/deliveryLogisticsAmount/queryDeliveryAmount")
    @LogIgnoreFeign(logMessage="queryDeliveryAmount",messageFieldName=ResponseCodeKeyConstant.MSG)
    QueryDeliveryAmountResponseDto queryDeliveryAmount(@RequestBody QueryDeliveryAmountRequestDto request);

    @PostMapping("/delivery/orderRemind")
    @LogIgnoreFeign(logMessage="orderRemind",messageFieldName=ResponseCodeKeyConstant.MSG)
    QueryDeliveryAmountResponseDto orderRemind(@RequestBody OrderRemindRequestDto request);

    @PostMapping("/delivery/listFreeRider")
    @LogIgnoreFeign(logMessage="listFreeRider",messageFieldName=ResponseCodeKeyConstant.MSG)
    MCCafeDeliveryBaseResponse<ResRiderTrackDto> listFreeRider(@RequestBody QueryLocusRiderTrackDto request);

    @PostMapping("/delivery/create")
    @LogIgnoreFeign(logMessage="deliveryOrderAdd",messageFieldName=ResponseCodeKeyConstant.MSG)
    CreateDeliveryOrderResponseDto deliveryOrderAdd(@RequestBody CreateDeliveryVo request);

    @PostMapping("/delivery/getDeliveryStatusAndRiderPosition")
    @LogIgnoreFeign(logMessage="getDeliveryStatusAndRiderPosition",messageFieldName=ResponseCodeKeyConstant.MSG)
    DeliveryBaseResponse<DeliveryStatusAndRiderPositionDto> getDeliveryStatusAndRiderPosition(@RequestBody QueryDeliveryBaseRequest queryDeliveryBaseRequest);

    @PostMapping("/delivery/getThirdDeliveryFlag")
    @LogIgnoreFeign(logMessage="getThirdDeliveryFlag",messageFieldName=ResponseCodeKeyConstant.MSG)
    DeliveryBaseResponse<GetDeliveryFlagResponseDto> getThirdDeliveryFlag(@RequestBody GetDeliveryFlagRequest getDeliveryFlagRequest);

    @PostMapping("/delivery/queryDeliveryTemplate")
    @LogIgnoreFeign(logMessage="queryDeliveryTemplate",messageFieldName=ResponseCodeKeyConstant.MSG)
    QueryDeliveryTemplateResponse queryDeliveryTemplate(@RequestBody QueryDeliveryTemplateRequest queryDeliveryTemplateRequest);

    @PostMapping("/delivery/isFreightRefundSupported")
    @LogIgnoreFeign(logMessage="isFreightRefundSupported",messageFieldName=ResponseCodeKeyConstant.MSG)
    QueryFreightRefundSupportedResponse isFreightRefundSupported(@RequestBody QueryFreightRefundSupportedVo queryDeliveryTemplateVo);


}
