package cn.freemud.entities.db;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;


@Data
@Table(name = "open_platform_partner_store_delivery_config")
public class OpenPlatformPartnerStoreDeliveryConfig {
    /**
     * 主键ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 品牌ID
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 门店ID
     */
    @Column(name = "store_id")
    private String storeId;

    /**
     * 配送起送费
     */
    @Column(name = "delivery_limit_amount")
    private Long deliveryLimitAmount;

    /**
     * 基础配送费
     */
    @Column(name = "delivery_amount")
    private Long deliveryAmount;

    /**
     * 默认配送公里数 3000 米
     */
    @Column(name = "default_delivery_range")
    private Long defaultDeliveryRange;

    /**
     * 每增加多少公里 单位米
     */
    @Column(name = "add_range_count")
    private Long addRangeCount;

    /**
     * 增加多少元 单位分
     */
    @Column(name = "add_range_amount")
    private Long addRangeAmount;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;
}