package cn.freemud.service.impl;

import cn.freemud.adapter.EvaluationAdapter;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.base.util.DateUtil;
import cn.freemud.entities.dto.AddProductEvaluationReqDto;
import cn.freemud.entities.dto.Evaluation.OrderEvaluationStatus;
import cn.freemud.entities.vo.AddUserOrderEvaluationNewRequestVo;
import cn.freemud.entities.vo.AddUserOrderEvaluationRequestVo;
import cn.freemud.entities.vo.GetEvaluationDetailByOrderIdRequestVo;
import cn.freemud.entities.vo.GetEvaluationStatusNewRequestVo;
import cn.freemud.enums.EvaluationStatus;
import cn.freemud.enums.ResponseResult;
import cn.freemud.service.EvaluationService;
import cn.freemud.utils.ResponseUtil;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOrderEvaluation;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentProductEvaluation;
import com.freemud.api.assortment.datamanager.entity.dto.InsertOrderEvaluationReqDto;
import com.freemud.api.assortment.datamanager.entity.dto.InsertProductEvaluationReqDto;
import com.freemud.api.assortment.datamanager.entity.vo.GetEvaluationDetailByOrderIdRepVo;
import com.freemud.api.assortment.datamanager.manager.AssortmentEvaluationManager;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.sdk.api.assortment.order.request.order.BaseQueryOrderRequest;
import com.freemud.sdk.api.assortment.order.response.order.OrderDetailResponse;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.com
 *
 * @version V1.0
 * @Title:
 * @Package: cn.freemud.service.impl
 * @Descripttion:
 * @author: shuhu.hou
 * @date: 2019/8/12
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目.
 */
@Service
public class EvaluationServiceImpl implements EvaluationService {

    @Autowired
    private OrderCenterSdkService orderCenterSdkService;
    @Autowired
    private AssortmentEvaluationManager assortmentEvaluationManager;
    @Autowired
    private EvaluationAdapter evaluationAdapter;

    @Override
    public BaseResponse userOrderEvaluationNew(AddUserOrderEvaluationNewRequestVo request) {
        try {
            BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
            baseQueryOrderRequest.setOrderId(request.getOrderId());
            OrderDetailResponse orderDetailResponse = orderCenterSdkService.getByIdForParentProduct(baseQueryOrderRequest);
            if (orderDetailResponse == null || !ResponseResult.SUCCESS.getCode().equals(orderDetailResponse.getErrcode() + "") || orderDetailResponse.getData() == null) {
                return ResponseUtil.success(ResponseResult.ORDER_NOT_EXIST);
            }
            QueryOrdersResponse.DataBean.OrderBean order = orderDetailResponse.getData();
            // 判断订单是否评价
            List<AssortmentOrderEvaluation> orderEvaluationDetails = assortmentEvaluationManager.getOrderEvaluationDetailsByOrderId(request.getOrderId());
            if (CollectionUtils.isNotEmpty(orderEvaluationDetails)) {
                return ResponseUtil.success(new OrderEvaluationStatus(EvaluationStatus.REPEAT.getCode()));
            }
            // 添加订单评价信息
            InsertOrderEvaluationReqDto insertOrderEvaluationReqDto = evaluationAdapter.convent2InsertOrderEvaluationReqDto(request, order);
            assortmentEvaluationManager.insertOrderEvaluationDetails(insertOrderEvaluationReqDto);
            // 添加订单下的商品评价信息
            List<AddProductEvaluationReqDto> addProductEvaluationList = request.getProductEvaluationList();
            if (CollectionUtils.isNotEmpty(addProductEvaluationList)) {
                for (AddProductEvaluationReqDto addProductEvaluationReqDto : addProductEvaluationList) {
                    InsertProductEvaluationReqDto insertProductEvaluationReqDto = evaluationAdapter.convent2InsertProductEvaluationReqDto(request, addProductEvaluationReqDto);
                    assortmentEvaluationManager.insertProductEvaluation(insertProductEvaluationReqDto);
                }
            }
        } catch (Exception ex) {
            ErrorLog.printErrorLog("userOrderEvaluationNewError", "/order/userOrderEvaluationNew", request, ex);
            return ResponseUtil.success(new OrderEvaluationStatus(EvaluationStatus.FAIL.getCode()));
        }
        return ResponseUtil.success(new OrderEvaluationStatus(EvaluationStatus.SUCCESS.getCode()));
    }

    @Override
    public BaseResponse getEvaluationByOrderId(GetEvaluationDetailByOrderIdRequestVo request) {
        if (StringUtils.isEmpty(request.getOrder_id())) {
            return ResponseUtil.success();
        }
        /**
         * 根据order_id 查询订单评价详情
         */
        List<AssortmentOrderEvaluation> orderEvaluationListAmount = assortmentEvaluationManager.getOrderEvaluationDetailsByOrderId(request.getOrder_id());
        if (orderEvaluationListAmount != null && orderEvaluationListAmount.size() > 0) {
            /**
             * 查询对应订单的商品详情
             */
            List<GetEvaluationDetailByOrderIdRepVo> getEvaluationDetailByOrderIdList = new ArrayList<>();
            for (AssortmentOrderEvaluation orderEvaluation : orderEvaluationListAmount) {
                GetEvaluationDetailByOrderIdRepVo getEvaluationDetailByOrderIdRepVo = new GetEvaluationDetailByOrderIdRepVo();
                List<AssortmentProductEvaluation> productEvaluationList = assortmentEvaluationManager.getProductEvalutionDetailsByOrderIds(Arrays.asList(orderEvaluation.getOrderId()));
                List<GetEvaluationDetailByOrderIdRepVo.ProductListVo> productList = new ArrayList<>();
                if (productEvaluationList != null && productEvaluationList.size() > 0) {
                    for (AssortmentProductEvaluation productEvaluation : productEvaluationList) {
                        GetEvaluationDetailByOrderIdRepVo.ProductListVo productListVo = new GetEvaluationDetailByOrderIdRepVo.ProductListVo();
                        productListVo.setIs_call(productEvaluation.getIsCall());
                        productListVo.setProduct_name(productEvaluation.getProductName());
                        productList.add(productListVo);
                    }
                }
                getEvaluationDetailByOrderIdRepVo.setCustomer_name(orderEvaluation.getCustomerName());
                getEvaluationDetailByOrderIdRepVo.setCustomer_mobile(orderEvaluation.getCustomerMobile());
                getEvaluationDetailByOrderIdRepVo.setStore_name(orderEvaluation.getStoreName());
                getEvaluationDetailByOrderIdRepVo.setCreate_time(DateUtil.convert2String(orderEvaluation.getCreateTime(), DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
                getEvaluationDetailByOrderIdRepVo.setDelivery_speed(orderEvaluation.getDeliverySpeed());
                getEvaluationDetailByOrderIdRepVo.setHealth(orderEvaluation.getHealth());
                getEvaluationDetailByOrderIdRepVo.setTaste(orderEvaluation.getTaste());
                getEvaluationDetailByOrderIdRepVo.setSurroundings(orderEvaluation.getSurroundings());
                getEvaluationDetailByOrderIdRepVo.setService(orderEvaluation.getService());
                getEvaluationDetailByOrderIdRepVo.setEvaluation_content(orderEvaluation.getEvaluationContent());
                getEvaluationDetailByOrderIdRepVo.setOrder_id(orderEvaluation.getOrderId());
                getEvaluationDetailByOrderIdRepVo.setOrder_type(orderEvaluation.getOrderType());
                getEvaluationDetailByOrderIdRepVo.setCreate_order_time(DateUtil.convert2String(orderEvaluation.getCreateOrderTime(), DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
                getEvaluationDetailByOrderIdRepVo.setProduct_evaluation_list(productList);
                getEvaluationDetailByOrderIdList.add(getEvaluationDetailByOrderIdRepVo);
            }
            return ResponseUtil.success(getEvaluationDetailByOrderIdList.get(0));
        }
        return ResponseUtil.success();
    }

    @Override
    public BaseResponse getEvaluationStatus(GetEvaluationDetailByOrderIdRequestVo request) {
        List<AssortmentOrderEvaluation> orderEvaluationListAmount = assortmentEvaluationManager.getOrderEvaluationDetailsByOrderId(request.getOrder_id());
        if (orderEvaluationListAmount != null && orderEvaluationListAmount.size() > 0) {
            return ResponseUtil.success(new OrderEvaluationStatus(1));
        } else {
            return ResponseUtil.success(new OrderEvaluationStatus(2));
        }
    }

    @Override
    public BaseResponse getEvaluationStatusNew(GetEvaluationStatusNewRequestVo request) {
        if (StringUtils.isEmpty(request.getOrderId())) {
            return ResponseUtil.success(new OrderEvaluationStatus(2));
        }
        List<AssortmentOrderEvaluation> orderEvaluationListAmount = assortmentEvaluationManager.getOrderEvaluationDetailsByOrderId(request.getOrderId());
        if (orderEvaluationListAmount != null && orderEvaluationListAmount.size() > 0) {
            return ResponseUtil.success(new OrderEvaluationStatus(1));
        } else {
            return ResponseUtil.success(new OrderEvaluationStatus(2));
        }
    }
}
