package cn.freemud.demo.service;

import cn.freemud.adapter.ShoppingCartConvertAdapter;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demo.entities.ResponseBuilder;
import cn.freemud.demo.entities.bo.goods.add.BaseAddGoodsBO;
import cn.freemud.demo.entities.dto.AddGoodsBaseResponseVO;
import cn.freemud.demo.manager.CustomerManager;
import cn.freemud.entities.vo.CustomerInfoVo;
import cn.freemud.entities.vo.ShoppingCartGoodsResponseVo;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public interface AddGoodsService {

    /**
     *
     * 检验客制化的参数
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse checkCustomParams(BaseAddGoodsBO baseRequestDTO) {
        return ResponseBuilder.success();
    }

    /**
     * 进行客制化的业务校验
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse checkCustomBusinessRules(BaseAddGoodsBO baseRequestDTO) {
        return ResponseBuilder.success();
    }

    /**
     * 获取购物车信息
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse getShoppingCartInfo(BaseAddGoodsBO baseRequestDTO) {
        return ResponseBuilder.success();
    }

    /**
     * 进行客制化的计算费用
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse calCustomCost(BaseAddGoodsBO baseRequestDTO) {
        return ResponseBuilder.success();
    }

    /**
     * 进行客制化的计算费用
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse setCustomMessage(BaseAddGoodsBO baseRequestDTO) {
        return ResponseBuilder.success();
    }


    /**
     * 封装客制化返回
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse buildCustomResponse(BaseAddGoodsBO baseRequestDTO) {
        return ResponseBuilder.success();
    }


//
//
//
//    /**
//     * 校验公共参数
//     * @param baseRequestDTO
//     * @return
//     */
//    default BaseResponse checkCommParams(BaseAddGoodsBO baseRequestDTO) {
//
//        return ResponseBuilder.success();
//    }
//
//    /**
//     * 进行公共的业务校验
//     * @param baseRequestDTO
//     * @return
//     */
//    default BaseResponse checkCommBusinessRules(BaseAddGoodsBO baseRequestDTO) {
//        // TODO checkCommBusinessRules
//        return ResponseBuilder.success();
//    }
//
//    /**
//     * 公共的计算费用
//     * @param baseRequestDTO
//     * @return
//     */
//    default BaseResponse calCommCost(BaseAddGoodsBO baseRequestDTO) {
//        // TODO calCommCost
//        return ResponseBuilder.success();
//    }
//
//    /**
//     * 公共的信息提醒
//     * @param baseRequestDTO
//     * @return
//     */
//    default BaseResponse setCommMessage(BaseAddGoodsBO baseRequestDTO) {
//        // TODO setCommMessage
//        return ResponseBuilder.success();
//    }
//
//    /**
//     * 封装公共返回
//     * @param baseRequestDTO
//     * @return
//     */
//    default BaseResponse buildCommResponse(BaseAddGoodsBO baseRequestDTO) {
//        // TODO buildCommResponse
//        return ResponseBuilder.success();
//    }
//


}
