package cn.freemud.demo.entities.bo.goods.add;

import cn.freemud.demo.entities.bo.goods.ProductBO;
import cn.freemud.demo.entities.bo.goods.ShoppingCartGoodsBO;
import lombok.Data;

@Data
public class BaseAddGoodsBO {

    private String sessionId;

    private String userId;

    private String partnerId;

    private String shopId;

    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    private String receiveId;

    /**
     * 操作类型 1= 添加商品券 2=加价购
     */
    private Integer operationType;

    /**
     * 优惠券号
     */
    private String couponCode;

    private ProductBO addGoods;

    private ShoppingCartGoodsBO oldShoppingCartGoods;

    private ShoppingCartGoodsBO newShoppingCartGoods;


    @Data
    public final static class Property {

        private String wxappid;

        /**
         * 下单类型 CreateOrderType 外卖、到店、商城
         */
        private Integer orderType;

        /**
         * 渠道类型 OrderChannelType
         */
        private String channelType;

        /**
         * 购物车版本号（拼单）
         */
        private Integer carVer;

        /**
         * 业务类型： 0 : 自提 1：外卖 2：微商城
         */
        private String menuType ;

        private String tableNumber;
    }

}
