package cn.freemud.demo.adapter;

import cn.freemud.adapter.ShoppingCartConvertAdapter;
import cn.freemud.demo.entities.bo.goods.ProductBO;
import cn.freemud.demo.entities.bo.goods.add.*;
import cn.freemud.demo.entities.dto.goods.add.*;
import cn.freemud.demo.enums.BizTypeEnum;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ServiceBOAdapter {

    public BaseAddGoodsBO convert2AddGoodsBO(String bizType, AddGoodsRequestDTO baseRequestDTO) {
        BaseAddGoodsBO baseAddGoodsBO;
        if (BizTypeEnum.MAIL.getCode().equals(bizType)){
            baseAddGoodsBO = createMallBO(baseRequestDTO);
        } else if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            baseAddGoodsBO = createMCoffeeBO(baseRequestDTO);
        } else {
            baseAddGoodsBO = createPlatformBO(baseRequestDTO);
        }
        return baseAddGoodsBO;
    }

    public BaseAddGoodsVO convert2AddGoodsVO(String bizType, BaseAddGoodsBO baseAddGoodsBO) {
        BaseAddGoodsVO baseAddGoodsVO;
        if (BizTypeEnum.MAIL.getCode().equals(bizType)){
            baseAddGoodsVO = createMallVO(baseAddGoodsBO);
        } else if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            baseAddGoodsVO = createMCoffeeVO(baseAddGoodsBO);
        } else {
            baseAddGoodsVO = createPlatformVO(baseAddGoodsBO);
        }
        return baseAddGoodsVO;
    }

    private PlatformAddGoodsBO createPlatformBO(AddGoodsRequestDTO baseRequestDTO) {
        PlatformAddGoodsBO platformAddGoodsBO = new PlatformAddGoodsBO();

        String skuId = StringUtils.isNotBlank(baseRequestDTO.getSkuId()) ? baseRequestDTO.getSkuId() : "";
        ProductBO productBO = convert2ProductVO();
        productBO.setSkuId(skuId);
        platformAddGoodsBO.setAddGoods(productBO);

        return platformAddGoodsBO;
    }

    private ProductBO convert2ProductVO() {
        return null;
    }

    private MCoffeeAddGoodsBO createMCoffeeBO(AddGoodsRequestDTO baseRequestDTO) {
        MCoffeeAddGoodsBO mCoffeeAddGoodsBO = new MCoffeeAddGoodsBO();
        return mCoffeeAddGoodsBO;
    }

    private MallAddGoodsBO createMallBO(AddGoodsRequestDTO baseRequestDTO) {
        MallAddGoodsBO mallAddGoodsBO = new MallAddGoodsBO();
        return mallAddGoodsBO;
    }

    private PlatformAddGoodsVO createPlatformVO(BaseAddGoodsBO baseAddGoodsBO) {
        PlatformAddGoodsVO platformAddGoodsVO = new PlatformAddGoodsVO();
        return platformAddGoodsVO;
    }

    private MCoffeeAddGoodsVO createMCoffeeVO(BaseAddGoodsBO baseAddGoodsBO) {
        MCoffeeAddGoodsVO mCoffeeAddGoodsVO = new MCoffeeAddGoodsVO();
        return mCoffeeAddGoodsVO;
    }

    private MallAddGoodsVO createMallVO(BaseAddGoodsBO baseAddGoodsBO) {
        MallAddGoodsVO mallAddGoodsVO = new MallAddGoodsVO();
        return mallAddGoodsVO;
    }

}
