package cn.freemud.service.impl;

import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.service.adapter.OrderManagerAdapter;
import cn.freemud.management.thirdparty.MulitiPaymentClient;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.ordercenter.request.OrderConditionsReq;
import com.freemud.application.sdk.api.ordercenter.service.OrderDownLoadSdkService;
import com.freemud.sdk.api.assortment.order.request.order.MultiOrderRefundRequest;
import com.freemud.sdk.api.assortment.order.response.order.MultiOrderRefundResponse;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.utils.ValidationCode;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;
import springfox.documentation.spring.web.json.Json;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class MallOrderServiceImplTest {

    @Autowired
    private OrderDownLoadSdkService orderDownLoadSdkService;

//    @Autowired
//    private MallOrderServiceImpl mallOrderService;
//
    @Autowired
    private MCCafeOrderServiceImpl mcCafeOrderService;
//
//    @Autowired
//    private MulitiPaymentClient mulitiPaymentClient;
//
//    @Autowired
//    private OrderManagerAdapter orderManagerAdapter;
    @Autowired
    private MulitiPaymentClient mulitiPaymentClient;
    @Autowired
    private OrderServiceImpl orderService;


    @Autowired
    private OrderManagerAdapter orderManagerAdapter;

//    @Before
//    public void before() throws Exception {
//    }
//
//    @After
//    public void after() throws Exception {
//    }

    @After
    public void after() throws Exception {
    }

    @Test
    public void f1() {
        mcCafeOrderService.createOrder(JSON.parseObject("{\"channelType\":\"saas\",\"partnerId\":\"1206\",\"appId\":\"wx6816a0b007741702\",\"sessionId\":\"db47c0d7f8238e7495cef5525d91b12befa6ce35\",\"orderType\":1,\"menuType\":\"saas\",\"shopId\":\"1450167\",\"couponCode\":\"\",\"buyMonthlyCard\":1,\"receiveId\":\"\"}", CreateOrderVo.class),
                new StoreResponse.BizVO(),
                JSON.parseObject("{\"activityDiscountsDtos\":[],\"deliveryAmount\":0,\"discountDeliveryAmount\":0,\"isDiscountDelivery\":false,\"originalTotalAmount\":500,\"packageAmount\":0,\"payCardFee\":0,\"products\":[{\"activityDiscountsDtos\":[],\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"categoryName\":\"\",\"classificationId\":\"\",\"classificationName\":\"\",\"customerCode\":\"110604\",\"extraList\":[],\"hasProductCoupon\":false,\"materialList\":[{\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"customerCode\":\"100072_2\",\"extraList\":[],\"hasProductCoupon\":false,\"originalPrice\":0,\"productCode\":\"100072_2\",\"qty\":1,\"specialExtra\":[],\"spuId\":\"189906104835159083\",\"spuName\":\"多糖浆\",\"stockLimit\":false,\"tax\":0.0,\"totalDiscountAmount\":0}],\"originalPrice\":0,\"picture\":\"https://picture.sandload.cn/1605493364971.png\",\"productCode\":\"110604\",\"qty\":1,\"skuId\":\"191616363987631633\",\"skuName\":\"4test\",\"specialExtra\":[{\"attributeId\":\"187910205014545213\",\"attributeName\":\"多冰\",\"specialCode\":\"110604_200002_2\"}],\"spuId\":\"191612801712731697\",\"spuName\":\"5test\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0},{\"activityDiscountsDtos\":[],\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"categoryName\":\"套餐\",\"classificationId\":\"\",\"classificationName\":\"\",\"comboProducts\":[{\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"customerCode\":\"110604\",\"extraList\":[],\"hasProductCoupon\":false,\"isFixedProduct\":true,\"materialList\":[{\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"customerCode\":\"100072_2\",\"extraList\":[],\"hasProductCoupon\":false,\"originalPrice\":0,\"productCode\":\"100072_2\",\"qty\":1,\"specialExtra\":[],\"spuId\":\"189906104835159083\",\"stockLimit\":false,\"tax\":0.0,\"totalDiscountAmount\":0}],\"originalPrice\":0,\"parentProductId\":\"191724441979486472\",\"picture\":\"https://picture.sandload.cn/1605493364971.png\",\"productType\":6,\"qty\":1,\"skuId\":\"191616363987631633\",\"skuName\":\"4test\",\"specialExtra\":[{\"attributeId\":\"187994174169235473\",\"attributeName\":\"少冰\",\"specialCode\":\"110604_200002_1_1\"}],\"spuId\":\"191612801712731697\",\"spuName\":\"5test\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0},{\"attributeNames\":\"{\\\"attributeNames\\\":\\\"\\\"}\",\"customerCode\":\"508664\",\"extraList\":[],\"hasProductCoupon\":false,\"isFixedProduct\":false,\"materialList\":[],\"originalPrice\":500,\"parentProductId\":\"191724441979486472\",\"picture\":\"https://picture.sandload.cn/1604910380410.png\",\"productType\":6,\"qty\":1,\"skuId\":\"191003415228296969\",\"skuName\":\"巴斯克芝士蛋糕\",\"spuName\":\"巴斯克芝士蛋糕\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0}],\"customerCode\":\"121431\",\"extraList\":[],\"hasProductCoupon\":false,\"materialList\":[],\"originalPrice\":0,\"picture\":\"https://picture.sandload.cn/1605605774124.png\",\"productCode\":\"121431\",\"productType\":6,\"qty\":1,\"skuId\":\"191724441979486472\",\"skuName\":\"啡常搭\",\"specialExtra\":[],\"spuId\":\"191724441979486472\",\"spuName\":\"啡常搭\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0}],\"totalAmount\":500,\"totalDiscountAmount\":0}", ShoppingCartGoodsDto.class),
                new OrderExtendedReq(),
                OrderClientType.SAAS,"www");
    }
//    @Test
//    public void testAffirm() {
//        OrderAffirmRequestVO requestVO = new OrderAffirmRequestVO();
//        requestVO.setPartnerId("1864");
//        requestVO.setShopId("8899");
//        requestVO.setSessionId("123123");
//        requestVO.setChannelType("saasmall");
//        requestVO.setOid("16303606485084241800003");
//        mallOrderService.orderAffirm(requestVO);
//    }

    @Test
    public void f2() {
        mcCafeOrderService.mcCafePaySuccessCallback(JSON.parseObject("{\"endTransId\":\"4200000731202010272812645480\",\"merchantCoupon\":0,\"openId\":\"oDF-Z5aYxM8xBKAzCeYCcdAIByT4\",\"partnerId\":\"1205\",\"platformCoupon\":0,\"platformMchId\":\"1259889901\",\"resultCode\":\"100\",\"thirdPartTradeNo\":\"4200000731202010272812645480\",\"totalAmount\":3800,\"tradeTime\":\"20201027170829\",\"transCurrency\":\"CNY\",\"transId\":\"19267384897250820300001\",\"transactionCode\":\"TSXA1205O230012700873498624\"}"
                , NewPaysuccessNoticeMessage.class));
    }

    @Test
    public void f3() {
        orderService.mcCafeQueryOrderById(JSON.parseObject("{\"channelType\":\"saas\",\"partnerId\":\"1206\",\"appId\":\"wx6816a0b007741702\",\"sessionId\":\"07e359b4147ef0182951b2c064f5ec8d716a702a\",\"orderType\":1,\"menuType\":\"saas\",\"shopId\":\"1450026\",\"oid\":\"19284932547021936900006\"}", MaCafeQueryOrderVo.class));
    }

    @Test
    public void test() {
//        MultiOrderRefundRequest multiOrderRefundRequest = new MultiOrderRefundRequest();
//        multiOrderRefundRequest.setFmId("");
//        multiOrderRefundRequest.setVer3(false);
//        multiOrderRefundRequest.setVer("V1");
//        multiOrderRefundRequest.setNotifyUrl("http://open-store-order-application-service.open-store.svc:9212/order/refundNotifyCallback");
//        multiOrderRefundRequest.setOperatorId("1");
//        multiOrderRefundRequest.setPartnerId("1864");
//        multiOrderRefundRequest.setRefundAmount(1L);
//        multiOrderRefundRequest.setRefundTradeNo("1604886134387{{$timestamp}}");
//        multiOrderRefundRequest.setStationId("1");
//        multiOrderRefundRequest.setStoreId("999999998");
//        multiOrderRefundRequest.setOutOrderNo("3900472893821604933666");
//        MultiOrderRefundResponse<MultiOrderRefundResponse.Data> multiOrderRefundResponseDto = mulitiPaymentClient.paymentApplicationRefund(multiOrderRefundRequest,"1864");
//        System.out.println(2345678);
//        OrderManagerRequest orderManagerRequest = new OrderManagerRequest();
//        orderManagerRequest.setOrderId("19404015572678969200003");
//        orderManagerRequest.setPartnerId("1864");
//        orderManagerAdapter.orderAgreeRefund(orderManagerRequest);
        OrderConditionsReq request ;
        String str = "{\"abnormalStatuses\":[],\"afterSalesStatus\":0,\"appId\":\"\",\"bizType\":0,\"bizTypes\":[1,6,97,98],\"dispenseStatus\":0,\"endTimestamp\":1605542399,\"endUpdateTimestamp\":0,\"expressType\":0,\"externalObjectIds\":[],\"finishStatus\":false,\"isDeleted\":0,\"mobile\":\"\",\"orderClients\":[],\"orderCode\":\"19356550932276285500005\",\"orderCodes\":[],\"orderStatus\":0,\"orderStatuses\":[],\"orderTypes\":[],\"pageNum\":1,\"pageSize\":10,\"partnerId\":\"2655\",\"payStatuses\":[2,3,4],\"payTypes\":[],\"printNum\":0,\"productId\":\"\",\"productName\":\"\",\"settlementTypes\":[],\"startTimestamp\":1604160000,\"startUpdateTimestamp\":0,\"storeIds\":[],\"suspendState\":0,\"thirdOrderCode\":\"\",\"userId\":\"\",\"userName\":\"\"}";
        request = JSON.toJavaObject(JSON.parseObject(str),OrderConditionsReq.class);
        orderDownLoadSdkService.queryOrderByConditions(request,"");
    }


}
