package cn.freemud.entities.dto;

import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class MemberRegisterRequestDto {
    /**
     * 原生卡ID
     */
    private String cardCode;

    private String cardId;

    /**
     * 渠道编码{xcx:会员小程序,dcxcx:点餐小程序,ptxcx:拼团小程序}
     */
    @NotNull
    private String channelCode;

    private String mobile;

    /**
     * 商户ID
     */
    @NotNull
    private String partnerId;

    /**
     * 是否需要初始化
     */
    @NotNull
    private String registerType;

    /**
     * 注册类型 页面注册、领卡、扫码、支付即会员  填2
     */
    private String registerInitData = "1#1#2#2#2";

    /**
     * 第三方code 微信oppenid、支付宝ID、线下导入ID、第三方ID
     */
    private String thirdPartyCode;

    /**
     * unionId
     */
    private String unionId;

    /**
     * nickName
     */
    private String nickName;
    /**
     * 头像地址
     */
    private String photoUrl;

    /**
     * 性别{0未知1男2女}
     */
    private String sexFlag;

    /**
     * 注册门店
     */
    private String registerStoreCode;

}
