/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ProductListDto
 * @Package cn.freemud.entities
 * @Description:
 * @author: ping.wu
 * @date: 2019/1/7 14:47
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
public class ProductListDto {

    private List<DataBean> data;
    private Integer errcode;
    private String errmsg;

    @NoArgsConstructor
    @Data
    public static class DataBean {

        private String barcode;
        private String brandId;
        private String brandName;
        private String category;
        private String categoryName;
        private String companyId;
        private String customerCode;
        /**
         * 最终价格 单位分
         */
        private Long finalPrice;
        private String name;
        /**
         * 原始价格 单位分
         */
        private Long originalPrice;
        /**
         * 包装费 单位分
         */
        private Long packPrice;

        private String picture;
        private String pid;
        private Integer pknumber;
        private String productionLocation;
        private String remark;
        private Integer saleCount;
        private String sellTimeName;
        private Integer sequence;
        private String sourceChannel;
        private String specification;
        private Integer status;
        private Integer stock;
        private int stockLimit;
        /**
         * type=10 多规格  type=1 单规格
         */
        private int type;
        private String unit;
        private int updateStatus;
        private boolean valid;
        private int version;
        private List<ProductLabelNameListBean> labelNames;
        private List<ProductAttributeGroupListBean> productAttributeGroupList;
        private List<?> productGroupList;
        private List<ProductPictureListBean> productPictureList;
        private List<?> productSpecification;
        private List<?> sellTimeList;
        private List<?> specificationList;
//        SKU
        private List<SkuProductBean> skuList;
        //规格信息
        private List<SpecificationGroupBean> specificationGroupList;
        //Sku 规格 如果 当前是sku 则有值
        private List<SkuProductBean.SkuSpecValue> skuSpecValues;

        @NoArgsConstructor
        @Data
        public static class SkuProductBean {
            private Long finalPrice;
            private Long originalPrice;
            private String productName;
            private Integer productType;
            private Integer sequence;
            private String skuCode;
            private String skuId;

            private Integer status;
            private List<SkuProductBean.SkuSpecValue> skuSpecValues;

            @NoArgsConstructor
            @Data
            public static class SkuSpecValue {
                private String productId;
                private Integer sequence;
                private String specId;
                private String specName;
                private String specValue;
                private String specValueId;
            }
        }

        @NoArgsConstructor
        @Data
        public static class SpecificationGroupBean {
            private String partnerId;
            private Integer sequence;
            private String specId;
            private String specName;
            private List<SpecificationGroupBean.SpecValueVo> specValueVos;

            @NoArgsConstructor
            @Data
            public static class SpecValueVo {
                private Integer sequence;
                private String specId;
                private String specValue;
                private String specValueId;
            }
        }

        @NoArgsConstructor
        @Data
        public static class ProductLabelNameListBean {
            private String id;
            private String name;
            private String partnerId;
            List<?> productList;
            private String storeId;
            private String type;
        }

        @NoArgsConstructor
        @Data
        public static class ProductAttributeGroupListBean {
            /**
             * attributeName : 加料
             * attributeType : 1
             * attributeValues : [{"attributeValue":"","id":0,"price":0,"sequence":0,"status":0}]
             */

            /**
             * 属性名称
             */
            private String attributeName;
            /**
             * 属性类型
             */
            private Integer attributeType;
            /**
             * 属性详细信息
             */
            private List<AttributeValueBean> attributeValues;

            @NoArgsConstructor
            @Data
            public static class AttributeValueBean {
                /**
                 * attributeValue :
                 * id : 0
                 * price : 0
                 * sequence : 0
                 * status : 0
                 */
                /**
                 * 属性值
                 */
                private String attributeId;

                private String attributeValue;
                /**
                 * 属性ID
                 */
                private Long id;
                /**
                 *
                 */
                private Long price;
                private Integer sequence;
                private Integer status;
            }
        }

        @NoArgsConstructor
        @Data
        public static class ProductPictureListBean {
            /**
             * pictureId : 107901339444445753
             * productId : 107901318808470072
             * sequence : 0
             * type : default
             * url : http://ojcpa0rpt.bkt.clouddn.com/xianfengfruit_DishPool_default_30b5f0ca-399a-4be3-9063-12a3d2622a38_1513952518.jpg
             */

            private String pictureId;
            private String productId;
            private String sequence;
            private String type;
            private String url;
        }
    }

}
