/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponService
 * @Package cn.freemud.service
 * @Description:
 * @author: pengfei.liu
 * @date: 2020/11/23
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.active.impl;

import cn.freemud.entities.dto.calculate.CalculationSharingDiscountRequestDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.enums.CalculationGoodsType;
import cn.freemud.service.active.ActiveService;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("platformActiveService")
public class PlatformActiveServiceImpl implements ActiveService {

    /**
     * 用户选择的商品和数量都要传给促销
     * @param calculationSharingDiscountRequestDto
     * @param chooseGoods
     */
    @Override
    public void buildChooseGoodsService(CalculationSharingDiscountRequestDto calculationSharingDiscountRequestDto, List<ShoppingCartInfoRequestVo.ChooseGood> chooseGoods) {

        // 买一赠一寄件活动
        List<CalculationSharingDiscountRequestDto.CalculationActivityReqVO> selectActivityList = calculationSharingDiscountRequestDto.getSelectActivityList() == null ? new ArrayList<>() : calculationSharingDiscountRequestDto.getSelectActivityList();

        if(null != chooseGoods && !chooseGoods.isEmpty()){

            CalculationSharingDiscountRequestDto.CalculationActivityReqVO  calculationActivityReqVO = new CalculationSharingDiscountRequestDto.CalculationActivityReqVO();

            List<CalculationSharingDiscountRequestDto.CalculationSendGoodsReqVO> sendGoods = new ArrayList<>();

            chooseGoods.forEach(chooseGood -> {
                calculationActivityReqVO.setActivityCode(chooseGood.getActiveCode());
                calculationActivityReqVO.setActivityType(ActivityTypeEnum.TYPE_63.getCode());
                CalculationSharingDiscountRequestDto.CalculationSendGoodsReqVO sendGood = new CalculationSharingDiscountRequestDto.CalculationSendGoodsReqVO();
                sendGood.setGoodsId(chooseGood.getGoodsId());
                sendGood.setGoodsQuantity(1);
                sendGoods.add(sendGood);
            });
            selectActivityList.add(calculationActivityReqVO);

        }
        calculationSharingDiscountRequestDto.setSelectActivityList(selectActivityList);

    }

    @Override
    public void gifAddCart(List<CartGoods> oldcartGoodsLists,
                           List<CartGoods> addcartGoodsList, List<ProductBeanDTO> products ,
                           ShoppingCartInfoRequestVo shoppingCartInfoRequestVo,
                           CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult) {

        Map<String, CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> discountForGift = this.getDiscountForGift(discountResult);

        for (ProductBeanDTO product : products) {
            String k = product.getPid();
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods goods = discountForGift.get(k);
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods.GoodsDiscount discount = goods.getDiscounts()
                    .stream()
                    .filter(g -> ActivityTypeEnum.TYPE_63.getCode().equals(g.getType()) ||ActivityTypeEnum.TYPE_62.getCode().equals(g.getType()) || ActivityTypeEnum.TYPE_61.getCode().equals(g.getType()))
                    .findFirst()
                    .get();
            CartGoods cartGood = new CartGoods();
            cartGood.setGoodsId(goods.getGoodsId());
            cartGood.setGoodsType(1);
            cartGood.setSpuId(goods.getGoodsId());
            cartGood.setSkuId(goods.getGoodsId());
            cartGood.setOriginalPrice(product.getFinalPrice());
            cartGood.setPackPrice(product.getPackPrice());
            cartGood.setOriginalAmount(goods.getOriginalPrice() * goods.getGoodsQuantity());
            cartGood.setAmount(goods.getRealAmount());
            cartGood.setName(product.getName());
            cartGood.setSpuName(product.getName());
            cartGood.setCategoryName(product.getName());
            cartGood.setPic(product.getPicture());
            cartGood.setSkuName(product.getName());
            cartGood.setActivityType(discount.getType());
            cartGood.setStockLimit(ObjectUtils.equals(1, product.getStockLimit()));
            cartGood.setCustomerCode(product.getCustomerCode());
            cartGood.setUnit(product.getUnit());
            cartGood.setWeight(product.getWeight());
            cartGood.setQty(goods.getGoodsQuantity());
            cartGood.setClassificationId(product.getCategory());
            cartGood.setClassificationName(product.getCategoryName());
            // nodeId标识activeCode,用于计算均摊时每个商品在每个活动上均摊金额
            cartGood.setNodeId(discount.getActivityCode());
            addcartGoodsList.add(cartGood);
        }
    }

    public Map<String, CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> getDiscountForGift(CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult) {

        Map<String, CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> gifts = discountResult.getGoods()
                .stream()
                .filter(d -> CalculationGoodsType.TYPE_1.getType().equals(d.getCartGoodType()))
                .collect(Collectors.toMap(CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods::getGoodsId, Function.identity(), (k1, k2) -> k1));
        return gifts;
    }

}
