package cn.freemud.manager;

import cn.freemud.entities.db.OpenPlatformIappWxappHomePageConfig;
import cn.freemud.manager.dao.OpenPlatformIappWxappHomePageConfigDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OpenPlatformIappWxappStoreManager
 * @Package cn.freemud.manager
 * @Description: 简单描述下这个类是做什么用的
 * @author: zhenghuan.yang
 * @date: 2018/9/6 13:23
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class OpenPlatformIappWxappHomePageConfigManager {

    @Autowired
    private OpenPlatformIappWxappHomePageConfigDao openPlatformIappWxappHomePageConfigDao;
    public List<OpenPlatformIappWxappHomePageConfig> selectHomePageConfigByPartnerIdAndAppId(String partnerId,String appId,String auditStatus) {
        OpenPlatformIappWxappHomePageConfig proramConfig=new OpenPlatformIappWxappHomePageConfig();
        proramConfig.setPartnerId(partnerId);
        proramConfig.setAppId(appId);
        proramConfig.setAuditStatus(auditStatus);
        return openPlatformIappWxappHomePageConfigDao.select(proramConfig);
    }
    public List<OpenPlatformIappWxappHomePageConfig> selectHomePageConfig(OpenPlatformIappWxappHomePageConfig request) {
        return openPlatformIappWxappHomePageConfigDao.select(request);
    }
    public OpenPlatformIappWxappHomePageConfig selectHomePageConfigById(Long id) {
        OpenPlatformIappWxappHomePageConfig request=new OpenPlatformIappWxappHomePageConfig();
        request.setId(id);
        return openPlatformIappWxappHomePageConfigDao.selectByPrimaryKey(request);
    }
    public int insert(OpenPlatformIappWxappHomePageConfig openPlatformIappWxappHomePageConfig) {
        return openPlatformIappWxappHomePageConfigDao.insert(openPlatformIappWxappHomePageConfig);
    }
    public int update(OpenPlatformIappWxappHomePageConfig openPlatformIappWxappHomePageConfig){
        return openPlatformIappWxappHomePageConfigDao.updateByPrimaryKeySelective(openPlatformIappWxappHomePageConfig);
    }
}
