/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartNewServiceTest
 * @Package cn.freemud.service
 * @Description:
 * @author: song.cai
 * @date: 2019/1/23 16:56
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ResponseResult;
import cn.freemud.service.impl.ShoppingCartMealServiceImpl;
import cn.freemud.service.impl.mcoffee.ShoppingCartMCoffeeServiceImpl;
import cn.freemud.service.impl.mcoffee.entity.MCoffeeAddGoodsRequestVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.freemud.sdk.api.assortment.shoppingcart.constant.MealClearOperationEnum;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class ShoppingCartMCoffeeServiceTest {

    @Autowired
    private ShoppingCartMCoffeeServiceImpl shoppingCartMCoffeeService;

    @Test
    public void f1() {
        shoppingCartMCoffeeService.addGoods(JSON.parseObject("{\"appId\":\"wx6816a0b007741702\",\"channelType\":\"saas\",\"couponCode\":\"601153527093109\",\"couponType\":0,\"extra\":[],\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"1628\",\"productComboList\":[{\"extra\":[],\"productMaterialList\":[],\"skuId\":\"204903200109635372\"}],\"productGroupList\":[],\"qty\":1,\"receiveId\":\"\",\"sessionId\":\"408cc5c5ce3967f849859d1cd11000ab1cf34729\",\"shopId\":\"99998\",\"skuId\":\"204906489299783199\",\"spuId\":\"204906489299783199\"}", MCoffeeAddGoodsRequestVo.class));
    }

    @Test
    public void f2() {
        shoppingCartMCoffeeService.updateGoodsQty(JSON.parseObject("{\"appId\":\"wx6816a0b007741702\",\"cartGoodsUid\":\"c9fd8e50-8dc9-48e2-a36e-bd6313ef81e9\",\"channelType\":\"saas\",\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"1206\",\"qty\":2,\"receiveId\":\"\",\"sessionId\":\"f3e238f5b30270ce4353695fe619fd6ddf9ce9ad\",\"shopId\":\"1450026\"}", UpdateShoppingCartGoodsQtyRequestVo.class));
    }

}
