/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponService
 * @Package cn.freemud.service
 * @Description:
 * @author: song.cai
 * @date: 2018/12/24 18:39
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.vo.*;

import java.util.List;
import java.util.Map;

public interface CouponService {
    /**
     * 获取优惠券列表
     *
     * @param getMemberCouponListRequestVo
     * @return
     */
//    BaseResponse<GetMemberCouponListResponseVo> getCouponList(GetMemberCouponListRequestVo getMemberCouponListRequestVo);

    /**
     * 添加到微信卡包
     *
     * @param requestVo
     * @return
     */
//    AddWeiXinCardResponseVo addWeiXinCard(AddWeiXinCardRequestVo requestVo);

    /**
     * 获取卡券详情
     *
     * @param requestVo
     * @return
     */
    GetCouponDetailResponseDto getMemberCoupon(GetMemberCouponRequestVo requestVo);

    List<GetMemberCouponListResponseDto.Result.MemberCoupon> getValidMemberCouponList(GetMemberCouponListRequestDto getMemberCouponListRequestDto, Integer orderType);

    /**
     * 批次查询券详情
     *
     * @param partnerId
     * @param storeId
     * @param codes
     * @return
     */
    List<GetCouponDetailResponseDto.Details> getMemberCoupons(String partnerId, String storeId, List<String> codes);

    /**
     * 获取麦咖啡卡券详情
     *
     * @param requestVo
     * @return
     */
//    GetCouponDetailResponseDto getMCCafeMemberCoupon(GetMemberCouponRequestVo requestVo);

    /**
     * 同步券到会员卡包(投放会员卡包)
     *
     * @param requestVo
     * @return
     */
//    BaseResponse receiveMemberCoupon(ReceiveMemberCouponRequestVo requestVo);

    /**
     * 调用会员接口列表
     *
     * @param cartGoods
     * @return
     */
    ActivityClassifyCouponBean availableCoupon(List<CartGoods> cartGoods, String partnerId, String userId, String storeId, String couponCode, boolean hasGoodsCoupon, Integer orderType, int isNew,String appId,String MenuType, String unChooseCouponCode);

    /**
     * 获取卡券服务商户密钥
     */
    String getAppSecret(String partnerId);

    /**
     * 获取卡券服务麦咖啡商户密钥
     */
//    String getMCCafeAppSecret(String partnerId);

    /**
     * 通过code校验券是否存在，返回商品券信息pid、price、code
     *
     * @param requestDto
     * @return
     */
    CheckSpqInfoResponseDto checkSpqInfo(CheckSpqInfoRequestDto requestDto);

    CheckSpqInfoResponseDto checkSpqInfo(CheckSpqInfoRequestDto requestDto, String goodsId);

    GetProductsVo getSpqProductInfo(CheckSpqInfoRequestDto requestDto);


    GetProductsVo getSpqProductInfo(CheckSpqInfoRequestDto requestDto, String goodsId);

//    /**
//     * 领券
//     *
//     * @param activityCodes
//     * @param partnerId
//     * @param storeId
//     * @param mobile
//     * @param userId
//     */
//    List<CreateCouponBeanVo> createCoupon(List<ActivityDiscountDto> activityCodes, String partnerId, String storeId, String mobile, String userId);


    GetCouponBarCodeResponseVo getCouponBarCode(String couponCode);

    /**
     *
     * @param partnerId
     * @param activityCodes
     * @param orderTye
     * 返回 key = 活动code， value=  返回是否匹配点餐方式
     */
    Map<String, Boolean> couponOrderWay(String partnerId, List<String> activityCodes, Integer orderTye);

    void checkValidCoupon(CouponPromotionVO couponPromotionVO, List<String> couponList, Map<String, List<String>> spqIdToCartUuid, String couponCode, List<CartGoods> cartGoodsList);
}
