package cn.freemud.demo.adapter.service;

import cn.freemud.demo.entities.bo.goods.ShoppingCartGoodsBO;
import cn.freemud.demo.entities.dto.goods.add.BaseAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.MCoffeeAddGoodsVO;
import cn.freemud.demo.entities.dto.goods.add.PlatformAddGoodsVO;
import cn.freemud.demo.enums.BizTypeEnum;
import cn.freemud.utils.BeanUtil;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class AddGoodsVOAdapter {

    @Resource
    private MapperFacade mapperFacade;

    public BaseAddGoodsVO convert2AddGoodsVO(String bizType, ShoppingCartGoodsBO baseAddGoodsBO) {
        BaseAddGoodsVO baseAddGoodsVO;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            baseAddGoodsVO = createMCoffeeVO(baseAddGoodsBO);
        } else {
            baseAddGoodsVO = createPlatformVO(baseAddGoodsBO);
        }
        return baseAddGoodsVO;
    }


    private PlatformAddGoodsVO createPlatformVO(ShoppingCartGoodsBO baseAddGoodsBO) {

        PlatformAddGoodsVO platformAddGoodsVO = BeanUtil.convertBean(baseAddGoodsBO, PlatformAddGoodsVO::new);
        return platformAddGoodsVO;
    }

    private MCoffeeAddGoodsVO createMCoffeeVO(ShoppingCartGoodsBO baseAddGoodsBO) {
        MCoffeeAddGoodsVO mCoffeeAddGoodsVO = new MCoffeeAddGoodsVO();
        return mCoffeeAddGoodsVO;
    }

}
