package cn.freemud.request.wechat.dto;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: SyncStatusDto
 * @Package cn.freemud.entities.dto
 * @Description: 订单微信上送DTO
 * @author: lox
 * @date: 2019/3/12 15:00
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class IndirectSyncStatusDto {
    /**
     * 服务商商户号
     */
    private String channel_id;
    /**
     * 子商户号
     */
    private String sub_mchid;
//    /**
//     * 服务商APPID
//     */
//    private String sp_appid;
    /**
     * 子商户APPID,非必填
     */
    private String sub_appid;
    /**
     * 门店编号
     */
    private String out_shop_no;
    /**
     * 用户标识,非必填
     */
    private String openid;
    /**
     * 用户子标识 ,非必填
     */
    private String sub_openid;
    /**
     * 登录票据(微信用户登录接口返回的登 录票据 公众号，填写access_token； 小程序，填写session_key；)
     */
    private String login_token;
    /**
     * 点餐入口(公众号：点餐页面完整URL 小程序：点餐页面path路径 )
     */
    private String order_entry;
    /**
     * 总价,单位为分
     */
    private int total_amount;
    /**
     * 优惠金额,单位为分
     */
    private int discount_amount;
    /**
     * 实际支付，单位为分
     */
    private int user_amount;
    /**
     * 订单状态 (CREATE_DEAL—用户下单；PAY_SUCCESS—支付完成)
     */
    private String status;
    /**
     * 状态发生变化的 时间
     */
    private String action_time;
    /**
     * 支付时间 （status为PAY_SUCCESS时 必填）
     */
    private String pay_time;
    /**
     * 微信支付订单号（status 为 PAY_SUCCESS时必填）
     */
    private String transaction_id;
    /**
     * 服务商支付订单号（status为PAY_SUCCESS时 必填）
     */
    private String out_trade_no;
    /**
     * 服务商订单号
     */
    private String out_order_no;
    /**
     * 菜品列表
     */
    private List<DishInfo> dish_list;
    /**
     * 桌位号,非必填
     */
    private String out_table_no;
    /**
     * 消费人数
     */
    private int people_count;

    @Data
    public static class DishInfo{
        /**
         * 商户菜品ID
         */
        private String out_dish_no;
        /**
         * 菜品名称
         */
        private String name;
        /**
         * 菜品单价,单位为分
         */
        private int price;
        /**
         * 菜品单位 (BY_SHARE-按份,BY_WEIGHT-按重量)
         */
        private String unit;
        /**
         * 菜品数量
         */
        private float count;
        /**
         * 菜品折扣，百分值，8折填80,非必填
         */
        private int discount;
        /**
         * 菜品分类 非必填
         */
        private String type;
        /**
         * 菜品优先级(当前菜品在服务商平台的顺序， 值越小越靠前，取值（1~100）),非必填
         */
        private int priority;

    }
}
