package cn.freemud.entities.db;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

@Data
@Table(name = "open_platform_iapp_wxapp_config")
public class OpenPlatformIappWxappConfig {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 自定义小程序appid
     */
    private String appid;

    /**
     * 微信小程序appid
     */
    @Column(name = "wx_appid")
    private String wxAppid;

    /**
     * 是否到店自取，0=否，1=是 v1.5.4新增
     */
    @Column(name = "take_inside")
    private Integer takeInside;

    /**
     * 是否外卖，0=未启动；1=启动；
     */
    private Integer takeaway;

    /**
     * 外卖类型  1=自配送；2=美团专送；……
     */
    @Column(name = "take_type")
    private Integer takeType;

    /**
     * 小程序按钮颜色
     */
    @Column(name = "background_colour")
    private String backgroundColour;

    /**
     * 猜你喜欢状态（1：开启，2：关闭）
     */
    @Column(name = "guess_like_status")
    private String guessLikeStatus;

    /**
     * 猜你喜欢栏目名称
     */
    @Column(name = "guess_like_name")
    private String guessLikeName;

    /**
     * 猜你喜欢显示条数
     */
    @Column(name = "guess_like_num")
    private Integer guessLikeNum;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

}