/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: WxappMessageTemplateManager
 * @Package cn.freemud.manager
 * @Description:
 * @author: liming.guo
 * @date: 2018/8/13 20:43
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.manager;

import cn.freemud.entities.db.WxappMessageTemplate;
import cn.freemud.manager.dao.WxappMessageTemplateDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class WxappMessageTemplateManager {

    @Autowired
    private WxappMessageTemplateDao wxappMessageTemplateDao;

    public List<WxappMessageTemplate> findTemplateByAppid(String appid) {
        return wxappMessageTemplateDao.selectByAppid(appid);
    }

    public WxappMessageTemplate findTemplateByParentIdAndAppid(Integer parentId, String appid) {
        return wxappMessageTemplateDao.selectParentIdAndAppid(parentId, appid);
    }
}
