package cn.freemud.service;

import cn.freemud.OrderApplication;
import cn.freemud.base.constant.Version;
import cn.freemud.base.log.LogTreadLocal;
import cn.freemud.entities.dto.BaseResponseDto;
import cn.freemud.entities.dto.QueryOrderByIdResponseDto;
import cn.freemud.entities.dto.coupon.MCCafeCouponRequest;
import cn.freemud.entities.dto.coupon.MCCafeCouponLockRequest;
import cn.freemud.entities.dto.coupon.MCCafeProductRedeemVo;
import cn.freemud.entities.dto.coupon.MCCafeTransactionVo;
import cn.freemud.enums.ReceiveOrderEnum;
import cn.freemud.service.impl.MCCafeOrderServiceImpl;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponBaseResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponQueryResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import cn.freemud.enums.CouponReqTypeEnum;
import cn.freemud.service.mccafe.thirdparty.CouponOfflineMCCafeClient;
import com.freemud.sdk.api.assortment.order.request.order.BaseQueryOrderRequest;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrderByIdResponse;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.List;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = OrderApplication.class)
public class CouponActivityServiceTest {

    @Autowired
    private CouponOfflineMCCafeClient offlineMCCafeClient;

    @Autowired
    private MCCafeOrderServiceImpl mcCafeOrderService;

    @Autowired
    private OrderCenterSdkService orderCenterSdkService;

    @Test
    public void redeemTest() {
        MCCafeCouponRequest couponCodeVerificationDto = new MCCafeCouponRequest();
        couponCodeVerificationDto.setVer(Integer.valueOf(Version.VERSION_1));
        couponCodeVerificationDto.setReqtype(CouponReqTypeEnum.REDEEM.getCode());
        couponCodeVerificationDto.setPartnerId(1206);
        couponCodeVerificationDto.setStore_id("khl-12345");
        couponCodeVerificationDto.setStation_id("1");
        couponCodeVerificationDto.setOperator_id("1");
        // 订单号
        couponCodeVerificationDto.setTrans_id("testRedeem0729009");
        couponCodeVerificationDto.setChannel("mocoffee_wx");
        List<MCCafeTransactionVo> transactions = new ArrayList<>();
        MCCafeTransactionVo mcCafeTransactionVo = new MCCafeTransactionVo();
        mcCafeTransactionVo.setCode("281168656683188");
        List<MCCafeProductRedeemVo> products = new ArrayList<>();
        MCCafeProductRedeemVo mcCafeProductRedeemVo = new MCCafeProductRedeemVo();
        mcCafeProductRedeemVo.setConsume_num(1);
        mcCafeProductRedeemVo.setPid("100057810020870000");
        mcCafeProductRedeemVo.setCustomer_code("11");
        mcCafeProductRedeemVo.setKeyProductCode("11");
        mcCafeProductRedeemVo.setSeq(1);
        products.add(mcCafeProductRedeemVo);
        mcCafeTransactionVo.setProducts(products);
        transactions.add(mcCafeTransactionVo);
        couponCodeVerificationDto.setTransactions(transactions);
        couponCodeVerificationDto.setSign("skip");

        System.out.println(JSON.toJSONString(couponCodeVerificationDto));
        CouponRedeemResponse couponCodeResponseDto = offlineMCCafeClient.redeem(couponCodeVerificationDto);
        System.out.println(couponCodeResponseDto);
    }

    @Test
    public void cancelRedeemTest() {
        MCCafeCouponRequest couponCodeVerificationDto = new MCCafeCouponRequest();
        couponCodeVerificationDto.setVer(Integer.valueOf(Version.VERSION_1));
        couponCodeVerificationDto.setReqtype(CouponReqTypeEnum.CANCEL_REDEEM.getCode());
        couponCodeVerificationDto.setPartnerId(1206);
        couponCodeVerificationDto.setStore_id("khl-12345");
        couponCodeVerificationDto.setStation_id("1");
        couponCodeVerificationDto.setOperator_id("1");
        // 订单号
        couponCodeVerificationDto.setTrans_id("testRedeem0729009");
        couponCodeVerificationDto.setChannel("mocoffee_wx");
        List<MCCafeTransactionVo> transactions = new ArrayList<>();
        MCCafeTransactionVo mcCafeTransactionVo = new MCCafeTransactionVo();
        mcCafeTransactionVo.setCode("297330216254368");
        List<MCCafeProductRedeemVo> products = new ArrayList<>();
        MCCafeProductRedeemVo mcCafeProductRedeemVo = new MCCafeProductRedeemVo();
        mcCafeProductRedeemVo.setConsume_num(1);
        mcCafeProductRedeemVo.setPid("100057810020870000");
        mcCafeProductRedeemVo.setCustomer_code("11");
        mcCafeProductRedeemVo.setKeyProductCode("11");
        mcCafeProductRedeemVo.setSeq(1);
        products.add(mcCafeProductRedeemVo);
        mcCafeTransactionVo.setProducts(products);
        transactions.add(mcCafeTransactionVo);
        couponCodeVerificationDto.setTransactions(transactions);
        couponCodeVerificationDto.setSign("skip");

        System.out.println(JSON.toJSONString(couponCodeVerificationDto));
        CouponRedeemResponse couponCodeResponseDto = offlineMCCafeClient.cancelRedeem(couponCodeVerificationDto);
        System.out.println(couponCodeResponseDto);
    }

    @Test
    public void queryTest() {
        MCCafeCouponRequest couponCodeVerificationDto = new MCCafeCouponRequest();
        couponCodeVerificationDto.setVer(Integer.valueOf(Version.VERSION_1));
        couponCodeVerificationDto.setReqtype(CouponReqTypeEnum.QUERY.getCode());
        couponCodeVerificationDto.setPartnerId(1206);
        couponCodeVerificationDto.setStore_id("khl-12345");
        couponCodeVerificationDto.setStation_id("1");
        couponCodeVerificationDto.setOperator_id("1");
        couponCodeVerificationDto.setChannel("mocoffee_wx");
        couponCodeVerificationDto.setCoupon("281168656683188");
        couponCodeVerificationDto.setSign("skip");

        System.out.println(JSON.toJSONString(couponCodeVerificationDto));
        CouponQueryResponse couponQueryResponse = offlineMCCafeClient.query(couponCodeVerificationDto);
        System.out.println(JSON.toJSONString(couponQueryResponse));
    }

    @Test
    public void lockTest() {
        MCCafeCouponLockRequest couponCodeVerificationDto = new MCCafeCouponLockRequest();
        couponCodeVerificationDto.setVer(Integer.valueOf(Version.VERSION_1));
        couponCodeVerificationDto.setReqType(89);
        couponCodeVerificationDto.setPartnerId("1206");
        couponCodeVerificationDto.setStoreId("99992");
        // 订单号
        couponCodeVerificationDto.setTransId("00000002");
        couponCodeVerificationDto.setOfferId("281168656683188");
        couponCodeVerificationDto.setCoupon("281168656683188");
        couponCodeVerificationDto.setNumber("1");
        couponCodeVerificationDto.setChannel("mocoffee_wx");
        couponCodeVerificationDto.setOperatorId("1");
        couponCodeVerificationDto.setStationId("1");
        couponCodeVerificationDto.setSign("ss");

        System.out.println(JSON.toJSONString(couponCodeVerificationDto));
        CouponBaseResponse couponCodeResponseDto = offlineMCCafeClient.lock(couponCodeVerificationDto);
        System.out.println(couponCodeResponseDto);
    }

    @Test
    public void unlockTest() {
        MCCafeCouponLockRequest couponCodeVerificationDto = new MCCafeCouponLockRequest();
        couponCodeVerificationDto.setVer(Integer.valueOf(Version.VERSION_1));
        couponCodeVerificationDto.setReqType(90);
        couponCodeVerificationDto.setPartnerId("1206");
        couponCodeVerificationDto.setStoreId("khl-12345");
        // 订单号
        couponCodeVerificationDto.setTransId("00000002");
        couponCodeVerificationDto.setOfferId("281168656683188");
        couponCodeVerificationDto.setCoupon("281168656683188");
        couponCodeVerificationDto.setNumber("1");
        couponCodeVerificationDto.setChannel("mocoffee_wx");
        couponCodeVerificationDto.setOperatorId("1");
        couponCodeVerificationDto.setStationId("1");
        couponCodeVerificationDto.setSign("ss");

        System.out.println(JSON.toJSONString(couponCodeVerificationDto));
        CouponBaseResponse couponCodeResponseDto = offlineMCCafeClient.unlock(couponCodeVerificationDto);
        System.out.println(couponCodeResponseDto);
    }

    @Test
    public void cancelDelivery() {
        BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
        baseQueryOrderRequest.setOrderId("18551043261893838300001");
        baseQueryOrderRequest.setTrackingNo(LogTreadLocal.getTrackingNo());
        QueryOrderByIdResponse queryOrderByIdResponse = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);
        String string = JSONObject.toJSONString(queryOrderByIdResponse);
        JSONObject jsonObject = JSONObject.parseObject(string);
        QueryOrderByIdResponseDto orderByIdResponseDto = jsonObject.toJavaObject(QueryOrderByIdResponseDto.class);
        
        BaseResponseDto baseResponseDto = mcCafeOrderService.cancelDelivery(orderByIdResponseDto.getData(), ReceiveOrderEnum.NOT_RECEIVE_ORDER.getDesc());
        System.out.println(JSON.toJSONString(baseResponseDto));
    }
}