/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ApiApplication
 * @Package cn.freemud
 * @Description:
 * @author: xudong.cai
 * @date: 2018/5/4 10:45
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud;

import cn.freemud.core.db.DataSourcesConfig;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import feign.RequestInterceptor;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import springfox.documentation.swagger2.annotations.EnableSwagger2;
import tk.mybatis.spring.annotation.MapperScan;

@ServletComponentScan
@ImportAutoConfiguration(classes = {DataSourcesConfig.class})
@EnableSwagger2
@EnableCircuitBreaker
@SpringBootApplication
@EnableDiscoveryClient
@EnableAspectJAutoProxy
@ComponentScan({"cn.freemud", "com.freemud"})
@MapperScan({"cn.freemud.*.dao","com.freemud.sdk.api.assortment.orderdistributor.mapper","com.freemud.api.assortment.datamanager.manager",
                "com.freemud.api.assortment.datamanager.queue.dao","com.freemud.api.assortment.datamanager.rbac.dao","com.freemud.api.assortment.datamanager.queue.entity"})
@EnableFeignClients({"cn.freemud.service.thirdparty","com.freemud.sdk.api.assortment.message","cn.freemud.service.mccafe.thirdparty"})
@EnableAutoConfiguration
public class OrderApplication {
    public static void main(String[] args) {
        SpringApplication.run(OrderApplication.class, args);
    }

    @Bean("jasyptStringEncryptorFreemud")
    public StringEncryptor stringEncryptor() {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword("configDbkey");
        config.setAlgorithm("PBEWithMD5AndDES");
        config.setKeyObtentionIterations("1000");
        config.setPoolSize("1");
        config.setProviderName("SunJCE");
        config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
        config.setStringOutputType("base64");
        encryptor.setConfig(config);
        return encryptor;
    }

    /**
     * 定义feign-client 带上x-transaction-id
     *
     * @return
     */
    @Bean
    public RequestInterceptor headerInterceptor() {
        return requestTemplate -> requestTemplate.header("x-tranaction-id", LogThreadLocal.getTrackingNo());
    }

}
