package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;

/**
 * @author wanghanghang
 * @title: CreateSpellGroupOrderReq
 * @projectName order-group
 * @description: 创建拼团订单request
 * @date 2021/4/14上午9:52
 */
@Data
public class CreateSpellGroupOrderReq {

    @NotEmpty(message = "商户号 不能为空")
    @ApiModelProperty(value = "商户号")
    private String partnerId;

    @NotEmpty(message = "sessionId 不能为空")
    @ApiModelProperty(value = "sessionId")
    private String sessionId;

    /**
     * 参与拼团编号->团编号
     */
    @ApiModelProperty(value = "参与拼团编号")
    private String spellGroupCode;

    @NotEmpty(message = "appId 不能为空")
    @ApiModelProperty(value = "appId")
    private String appId;

    /**
     * 渠道类型 OrderChannelType
     */
    @ApiModelProperty(value = "渠道类型")
    private String channelType = "saasmall";

    /**
     * 下单支付渠道类型
     */
    @NotNull(message = "下单支付渠道类型不能为空")
    @ApiModelProperty(value = "下单支付渠道类型")
    private Byte payChannelType;

    /**
     * 订单类型  1 到店自取 2 外卖   枚举CreateOrderType
     */
    @Builder.Default
    private Integer orderType = 3;

    @Builder.Default
    @ApiModelProperty(value = "订单特殊类型 1:普通订单 2:拼团订单 3:秒杀订单 4:拼单订单")
    private Integer marketingType = 2;

    @NotEmpty(message = "收货地址 不能为空")
    @ApiModelProperty(value = "收货地址")
    private String receiveAddress;

    @NotEmpty(message = "收货用户名 不能为空")
    @ApiModelProperty(value = "收货用户名")
    private String receiveUsername;

    @NotEmpty(message = "收货电话 不能为空")
    @Pattern(regexp = "^1[3|4|5|6|7|8|9][0-9]{9}$", message = "手机号码格式不正确")
    @ApiModelProperty(value = "收货电话")
    private String receiveMobile;

    @NotEmpty(message = "拼团活动号不能为空")
    @ApiModelProperty(value = "拼团活动号")
    private String activityCode;

    @NotNull(message = "拼团商品信息不能为空")
    @ApiModelProperty(value = "拼团商品集合")
    private List<SpellGroupProduct> spellGroupProductList;

    /**
     * 城市编号。用于查询配送费
     */
    @NotEmpty(message = "城市编号不能为空")
    @ApiModelProperty(value = "城市编号")
    private String province;

    /**
     * 拼团商品
     */
    @Data
    public static class SpellGroupProduct {
        private String productId;
        private Integer productQuantity;
    }

}
