package cn.freemud.service.mccafe;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.management.entities.dto.response.coupon.McdNetBatchQueryResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponBaseResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponQueryResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import cn.freemud.management.entities.dto.request.order.MCCafeCouponRequest;
import cn.freemud.management.entities.dto.request.order.MCCafeCouponLockRequest;
import com.freemud.sdk.api.assortment.order.request.order.CreateOrderAccountRequest;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;

import java.util.List;

public interface CouponClientService {

    CouponRedeemResponse redeem(QueryOrdersResponse.DataBean.OrderBean orderBean, List<CreateOrderAccountRequest> accounts);

    CouponRedeemResponse redeem(MCCafeCouponRequest mcCafeCouponRequest);

    CouponRedeemResponse redeemBatch(QueryOrdersResponse.DataBean.OrderBean orderBean, List<CreateOrderAccountRequest> accounts);

    List<CouponRedeemResponse> redeemBatch(QueryOrdersResponseDto.DataBean.OrderBean orderBean);

    CouponRedeemResponse cancelRedeem(QueryOrdersResponse.DataBean.OrderBean orderBean, List<CreateOrderAccountRequest> accounts);

    CouponQueryResponse query(MCCafeCouponRequest mcCafeCouponRequest);

    McdNetBatchQueryResponse batchQuery(MCCafeCouponRequest mcCafeCouponRequest);

    CouponBaseResponse lock(QueryOrdersResponse.DataBean.OrderBean orderBean, List<CreateOrderAccountRequest> accounts);

    CouponBaseResponse lock(MCCafeCouponLockRequest mcCafeCouponLockRequest);

    CouponBaseResponse lockBatch(QueryOrdersResponse.DataBean.OrderBean orderBean, List<CreateOrderAccountRequest> accounts);

    List<CouponBaseResponse> lockBatch(QueryOrdersResponseDto.DataBean.OrderBean orderBean);

    CouponBaseResponse unlock(MCCafeCouponLockRequest mcCafeCouponLockRequest);

    /**
     * 移除卡包
     * @param orderBean
     * @return
     */
    BaseResponse callbackNotify(QueryOrdersResponseDto.DataBean.OrderBean orderBean) ;
}
