package cn.freemud.entities.vo;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: QueryReceiveAddressResponseVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/7/3 21:23
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
@NoArgsConstructor
public class QueryReceiveAddressResponseVo {

    private Integer total;
    private Integer pageNo;
    private Integer pageSize;

    List<ReceivingAddress> enableDeliveryList;

    List<ReceivingAddress> disableDeliveryList;

    List<ReceivingAddress> list;



    @NoArgsConstructor
    @Data
    public static class ReceivingAddress {

        private String receiveId;
        private String latitude;
        private String longitude;
        private Integer sex;
        private String sexDesc;
        private Integer isDefault;
        /**
         * 收货办公楼
         */
        private String officeName;
        /**
         * 收货地址
         */
        private String receiveAddress;
        /**
         * 收货用户名
         */
        private String receiveUsername;
        /**
         * 收货电话
         */
        private String receiveMobile;
        /**
         * 标签
         */
        private String label;
        /**
         * 是否在外卖可配送范围内
         */
        private Boolean enableTakeaway;

        private Double distance;
        /**
         * 收货地址与门店之间的配送费
         */
        private Long deliveryAmount;
    }
}