/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartBaseServiceImpl
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: liming.guo
 * @date: 2018/6/28 19:49
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.impl;

import cn.freemud.constant.RedisKeyConstant;
import cn.freemud.entities.vo.CartGoods;
import cn.freemud.service.ShoppingCartNewBaseService;
import com.freemud.application.sdk.api.base.SDKCommonBaseContextWare;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;

@Service
public class ShoppingCartNewBaseServiceImpl implements ShoppingCartNewBaseService {

    private final CartGoodsComparator cartGoodsComparator = new CartGoodsComparator();

    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private AssortmentSdkService assortmentSdkService;

    @Override
    public List<CartGoods> add(String partnerId, String storeId, String userId, CartGoods cartGoods) {
        BoundHashOperations<String, String, CartGoods> operations = this.getShoppingCartGoodsZSetOperations(partnerId, storeId, userId);
        operations.put(cartGoods.getCartGoodsUid(), cartGoods);
        return assortmentSdkService.getShoppingCart(partnerId, storeId, userId,null,null, SDKCommonBaseContextWare.getBean(ShoppingCartBaseServiceImpl.class));
    }

    @Override
    public void clear(String partnerId, String storeId, String userId) {
        redisTemplate.delete(this.getShoppingCartGoodsKey(partnerId, storeId, userId));
        //redisTemplate.delete(this.getShoppingCartGoodsAmountKey(partnerId, storeId, userId));
    }


    private BoundHashOperations getShoppingCartGoodsZSetOperations(String partnerId, String storeId, String userId) {
        String key = this.getShoppingCartGoodsKey(partnerId, storeId, userId);
        return redisTemplate.boundHashOps(key);
    }

    /**
     * 获取记录购物车信息的key
     *
     * @param partnerId
     * @param storeId
     * @param userId
     * @return
     */
    private String getShoppingCartGoodsKey(String partnerId, String storeId, String userId) {
        return RedisKeyConstant.SAAS_SHOPPINGCART_KEY_PREFIX + partnerId + "_" + storeId + "_" + userId;
    }

    /**
     * 获取记录购物车价格的key
     *
     * @param partnerId
     * @param storeId
     * @param userId
     * @return
     */
    private String getShoppingCartGoodsAmountKey(String partnerId, String storeId, String userId) {
        return RedisKeyConstant.SAAS_SHOPPINGCART_AMOUNT_PREFIX + partnerId + "_" + storeId + "_" + userId;
    }

    public static class CartGoodsComparator implements Comparator<CartGoods> {
        @Override
        public int compare(CartGoods o1, CartGoods o2) {
            return (int) (o1.getCreateTimeMili() - o2.getCreateTimeMili());
        }
    }
}
