package cn.freemud.demoTest.entities.bo;


import lombok.Data;

@Data
public class BasePaySuccessBo {

    /**
     * 接口版本
     */
    private Integer resultCode;
    /**
     * 非码交易流水号 fmID
     */
    private String outTradeNo;
    /**
     * 支付时终端交易序号
     */
    private String transId;
    /**
     * 订单金额
     */
    private Integer totalFee;
    /**
     * 营业员编号
     */
    private String openid;
    /**
     * 平台优惠
     */
    private double platformCoupon;
    /**
     * 商家优惠
     */
    private double merchantCoupon;
    /**
     * 平台支付订单号(微信订单号)
     */
    private String paidNo;
    /**
     * 渠道方流水号 （比如扫呗，易宝等） 新支付服务做中转使用
     */
    private String endTransId;

    /**
     * 第三方支付商户号 新支付服务做中转使用
     */
    private String platformMchId;
    /**
     * 扫呗商户号 新支付服务做中转使用
     */
    private String terminalId;
    /**
     * 会员规则ID
     */
    private String ruleId;

    /**
     * 消息来源
     */
    private Integer source;

}
