package cn.freemud.sdk.test;

import cn.freemud.platform.sdk.common.service.CloudService;
import cn.freemud.platform.sdk.hualala.HualalaSdkService;
import cn.freemud.platform.sdk.hualala.request.GetPaySubjectRequest;
import cn.freemud.platform.sdk.hualala.request.HuaLaLaCommonRequest;
import cn.freemud.platform.sdk.hualala.request.HualalaBaseConfig;
import cn.freemud.platform.sdk.hualala.request.SubmitOrderNewRequest;
import cn.freemud.platform.sdk.hualala.response.GetPaySubjectResponse;
import cn.freemud.platform.sdk.hualala.response.SubmitOrderNewResponse;
import com.alibaba.fastjson.JSON;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.web.client.RestTemplate;

import java.util.UUID;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: ${TODO}(用一句话描述该文件做什么)
 * @author: aiqi.gong
 * @date: 2019/3/18 21:53
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

public class TestHuaLaLa {



    @Test
    public void testOrder() {
        RestTemplate restTemplate = new RestTemplate();
        CloudService cloudService = new CloudService(restTemplate);
        HualalaSdkService hualalaSdkService = new HualalaSdkService(cloudService);
        HuaLaLaCommonRequest huaLaLaCommonRequest = new HuaLaLaCommonRequest();
        huaLaLaCommonRequest.setDevID(119L);
        huaLaLaCommonRequest.setGroupID(1155L);
        huaLaLaCommonRequest.setMerchantsID(118L);
        huaLaLaCommonRequest.setShopID(76056109L);
        huaLaLaCommonRequest.setVersion(1.0);
        huaLaLaCommonRequest.setTimestamp(System.currentTimeMillis());
        SubmitOrderNewRequest submitOrderNewRequest = getSubmitOrderNewRequest();

        HualalaBaseConfig hualalaBaseConfig = new HualalaBaseConfig();
        hualalaBaseConfig.setDevPwd("nI83qiNK");
        hualalaBaseConfig.setMerchantSecret("i28cUu3v");

        SubmitOrderNewResponse resBody = hualalaSdkService.submitOrder(UUID.randomUUID().toString(),hualalaBaseConfig, huaLaLaCommonRequest, submitOrderNewRequest);
        Assert.assertEquals(resBody.getCode(), "000");
    }
    @Test
    public void testMoTiOrder() {
        RestTemplate restTemplate = new RestTemplate();
        CloudService cloudService = new CloudService(restTemplate);
        HualalaSdkService hualalaSdkService = new HualalaSdkService(cloudService);
        HuaLaLaCommonRequest huaLaLaCommonRequest = new HuaLaLaCommonRequest();
        huaLaLaCommonRequest.setDevID(1017L);
        huaLaLaCommonRequest.setGroupID(37087L);
        huaLaLaCommonRequest.setMerchantsID(10L);
        huaLaLaCommonRequest.setShopID(76087355L);
        huaLaLaCommonRequest.setVersion(2.0);
        huaLaLaCommonRequest.setTimestamp(System.currentTimeMillis());
        SubmitOrderNewRequest submitOrderNewRequest = getSubmitOrderNewRequest();

        HualalaBaseConfig hualalaBaseConfig = new HualalaBaseConfig();
        hualalaBaseConfig.setDevPwd("FOMot5JE");
        hualalaBaseConfig.setMerchantSecret("FOMot5JE");

        SubmitOrderNewResponse resBody = hualalaSdkService.submitOrder(UUID.randomUUID().toString(),hualalaBaseConfig, huaLaLaCommonRequest, submitOrderNewRequest);
        Assert.assertEquals(resBody.getCode(), "000");
    }
    @Test
    public void getSubject() {
        RestTemplate restTemplate = new RestTemplate();
        CloudService cloudService = new CloudService(restTemplate);
        HualalaSdkService hualalaSdkService = new HualalaSdkService(cloudService);
        HuaLaLaCommonRequest huaLaLaCommonRequest = new HuaLaLaCommonRequest();
        huaLaLaCommonRequest.setDevID(119L);
        huaLaLaCommonRequest.setGroupID(1155L);
        huaLaLaCommonRequest.setMerchantsID(118L);
        huaLaLaCommonRequest.setShopID(76056109L);
        huaLaLaCommonRequest.setVersion(1.0);
        huaLaLaCommonRequest.setTimestamp(System.currentTimeMillis());

        GetPaySubjectRequest getPaySubjectRequest = new GetPaySubjectRequest();
        getPaySubjectRequest.setMerchantsName("桂源铺");
        GetPaySubjectResponse resBody = hualalaSdkService.getPaySubject(UUID.randomUUID().toString(), huaLaLaCommonRequest, getPaySubjectRequest);
        System.out.println(JSON.toJSONString(resBody.getData()));
        Assert.assertEquals(resBody.getCode(), "000");
    }


    public static SubmitOrderNewRequest getSubmitOrderNewRequest() {
        SubmitOrderNewRequest submitOrderNewRequest = JSON.parseObject("{\"bankCode\":\"weChat\",\"header\":{\"traceID\":\"9e2e320dd6e144cebc3b3dabf41d3208\"},\"isCheackOut\":0,\"isSentMsg\":1,\"isThirdPay\":2,\"msgType\":21,\"order\":{\"channelKey\":\"310_wechat000\",\"deliveryAmount\":\"0\",\"dinners\":1,\"discountTotalAmount\":\"0\",\"isAlreadyPaid\":\"1\",\"orderItem\":[{\"duePrice\":\"11.5\",\"foodCount\":1,\"foodID\":\"126062\",\"foodName\":\"(M)黄金乌龙奶盖\",\"foodUnit\":\"(M)黄金乌龙奶盖/常规\",\"foodUnitID\":\"12606240\",\"isBatching\":0,\"isDiscount\":1,\"isSetFood\":\"0\",\"originPrice\":\"14\",\"takeoutPackagingFee\":\"0.00\"},{\"duePrice\":\"11.5\",\"foodCount\":1,\"foodID\":\"12625332\",\"foodName\":\"(M)坚果可可奶盖\",\"foodUnit\":\"(M)坚果可可奶盖/常规\",\"foodUnitID\":\"12625339\",\"isBatching\":0,\"isDiscount\":1,\"isSetFood\":\"0\",\"originPrice\":\"14\",\"takeoutPackagingFee\":\"0.00\"}],\"orderRemark\":\"\",\"orderStatus\":20,\"orderSubType\":21,\"orderTime\":\"201903251244\",\"payment\":[{\"dueAmount\":\"23\",\"payWay\":\"70\",\"paymentStatus\":\"20\",\"paymentSubjectID\":\"11311010\",\"paymentSubjectName\":\"微信支付\"}],\"serviceAmount\":\"0\",\"takeoutAddress\":\"\"},\"orderStatus\":20,\"thirdOrderID\":\"139593703936351285\"}", SubmitOrderNewRequest.class);
        return submitOrderNewRequest;
    }

   /* private static String getSignStr(HuaLaLaCommonRequest commonRequest, SubmitOrderNewRequest submitOrderNewRequest, String devPwd) {
        Map<String, Object> headMap = CustomBeanUtil.java2Map(commonRequest);
        Map<String, Object> bodyMap = CustomBeanUtil.java2Map(submitOrderNewRequest);

        Map<String, String> allMap = new HashMap<>();
        for (Map.Entry<String, Object> entry : headMap.entrySet()) {
            String value = ObjectUtils.isEmpty(entry.getValue()) ? "" : entry.getValue().toString();
            if (!StringUtils.isEmpty(value) && !allMap.containsKey(entry.getKey())) {
                allMap.put(entry.getKey(), value);
            }
        }
        for (Map.Entry<String, Object> entry : bodyMap.entrySet()) {
            String value = ObjectUtils.isEmpty(entry.getValue()) ? "" : entry.getValue().toString();
            if (!StringUtils.isEmpty(value) && !allMap.containsKey(entry.getKey())) {
                allMap.put(entry.getKey(), value);
            }
        }
        allMap.remove("signature");
        allMap.remove("requestBody");
        allMap.remove("header");
        allMap.remove("order");
        allMap.put("devPwd", devPwd);
        Map<String, String> sortMap = CustomBeanUtil.sortStrMapByKey(allMap);

        StringBuilder sb = new StringBuilder();
        sb.append("key");
        for (Map.Entry<String, String> entry : sortMap.entrySet()) {
            if (!ObjectUtils.isEmpty(entry.getValue())) {
                sb.append(entry.getKey()).append(entry.getValue());
            }
        }
        sb.append("secret");

        //boolean equals = sb.toString().equals("keybankCodeWechatcheckoutType2devID119devPwdnI83qiNKgroupID1155isCheackOut0isSentMsg1isThirdPay2merchantsID118timestamp1553013174version1.0secret");


        return  bytesToHexString(DigestUtils.sha1(sb.toString())).toUpperCase();
    }

    private static String getRequestBodyStr(SubmitOrderNewRequest submitOrderNewRequest, String merchantAppSecret) {
        String reqString = JSONObject.toJSONString(submitOrderNewRequest);
        String key = merchantAppSecret + merchantAppSecret;
        return AesCBCNoPaddingUtil.encrypt(reqString, key, key);
    }
    private static String bytesToHexString(byte[] src){
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; i++) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }*/


}
