package cn.freemud.client;

import cn.freemud.entities.dto.BatchQueryActivityInfoRequestDto;
import cn.freemud.service.CouponService;
import cn.freemud.service.thirdparty.CouponOnlineClient;
import com.freemud.application.sdk.api.util.SignUtil;
import com.google.gson.Gson;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class CouoponOnlineTest {
    private static Gson gson = new Gson();
    @Autowired
    private CouponOnlineClient couponOnlineClient;
    @Autowired
    private CouponService couponService;
    @Test
    public void getCouponDetailsMD5() {
        String appSecret=couponService.getAppSecret("1864");
        Map<String, String> requestDto = new TreeMap<String, String>();
        requestDto.put("codes","88600017957274347573");
        requestDto.put("partner_id","1864");
        requestDto.put("merchant_id","1864");
        requestDto.put("action","code.allDetails");
        String sign= SignUtil.createMD5Sign(requestDto,appSecret);
        requestDto.put("sign",sign);
        Object responseDto2 = couponOnlineClient.getCouponDetails(requestDto);
    }

    @Test
    public void batchQueryActivityInfoTest() {
        String appSecret=couponService.getAppSecret("1864");
        BatchQueryActivityInfoRequestDto requestDto = new BatchQueryActivityInfoRequestDto();
        requestDto.setActiveCode(Arrays.asList("D1552902452163158"));
        requestDto.setIsProduct(1);
        requestDto.setPartnerId(1864);
        String sign = SignUtil.createMD5Sign(requestDto, appSecret);
        requestDto.setSign(sign);
//        BatchQueryActivityInfoResponseDto batchQueryActivityInfoResponseDto = cardBinClient.batchQueryActivityInfo(requestDto);

    }

}
