package cn.freemud.service.thirdparty;

import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.product.ValiadShopProductResponse;
import cn.freemud.entities.dto.product.ValidateShopProductRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: null.java
 * @Package
 * @Description: (用一句话描述该文件做什么)
 * @author: 蓝胖子(Hector)
 * @date: 2019-11-20
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */

@FeignClient(name = "PRODUCTSERVICE", url = "${saas.storeitemclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface ProductClient {

    @PostMapping({"/Shop/ListMenuMustProduct"})
    @IgnoreFeignLogAnnotation(logMessage = "getRequiredProductList",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.ERR_CODE,messageFieldName = ResponseCodeKeyConstant.ERR_MSG)
    ProductBaseResponse<List<String>> getRequiredProductList(@RequestBody RequiredProductRequest request);


    @PostMapping({"/Shop/ValidateShopProduct/Reason"})
    @IgnoreFeignLogAnnotation(logMessage = "validateShopProductAboutReason",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.ERR_CODE,messageFieldName = ResponseCodeKeyConstant.ERR_MSG)
    ProductBaseResponse<ValiadShopProductResponse> validateShopProductAboutReason(@RequestBody ValidateShopProductRequest request);


    /**
     * 获取门店特定时间段菜单分类
     */
    @PostMapping(value = "/Menu/GetMenu")
    @IgnoreFeignLogAnnotation(logMessage = "getMenuCategory",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    GetMenuResponseDto getMenuCategory(@RequestBody GetMenuCategoryInfoDto getMenuCategoryInfoDto);

    /**
     * 根据spu或单品ID查询菜单
     * 根据商品id查询门店特定时间段菜单
     */
    @PostMapping(value = "/Menu/GetMenuByIds")
    @IgnoreFeignLogAnnotation(logMessage = "getMenuCategoryByIds",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.ERR_CODE,messageFieldName=ResponseCodeKeyConstant.MEG)
    GetMenuByIdsResponseDto getMenuCategoryByIds(@RequestBody GetMenuCategoryByIdsDto getMenuCategoryByIdsDto);

    /**
     * 获取商品的详细信息
     */
    @PostMapping("/Shop/ListProductInfoByIdList")
    @IgnoreFeignLogAnnotation(logMessage = "listProductInfos",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.ERR_CODE,messageFieldName=ResponseCodeKeyConstant.MEG)
    ProductInfosDto listProductInfos(@RequestBody GetProductInfoDto getProductInfoDto);

    /**
     * 根据skuid查询spu信息
     * @return
     */
    @PostMapping("/Product/GetSpectionProductBySkuId")
    @IgnoreFeignLogAnnotation(logMessage = "getSpuIdsBySkuIds",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.ERR_CODE,messageFieldName=ResponseCodeKeyConstant.MEG)
    ProductListDto getSpuIdsBySkuIds(@RequestBody GetSpuIdsBySkuIdsDto requestDto);

    /**
     * 校验商品可用性
     */
    @PostMapping("Shop/ValidateShopProduct")
    @IgnoreFeignLogAnnotation(excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.ERR_CODE,messageFieldName=ResponseCodeKeyConstant.MEG)
    ProductBaseResponse<ValiadShopProductResponse> validateShopProduct(@RequestBody ValidateShopProductRequest request);

    /**
     * 校验商品在当前门店是否可售
     */
    @PostMapping("/Shop/validateShopContainProduct")
    @IgnoreFeignLogAnnotation(logMessage = "validateShopContainProduct",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.ERR_CODE,messageFieldName=ResponseCodeKeyConstant.MEG)
    ValidateProductInfosDto validateShopContainProduct(@RequestBody GetValidateProductInfoDto getProductInfoDto);
}
