package cn.freemud.management.service.adapter;

import cn.freemud.management.service.OrderManagerService;
import cn.freemud.management.service.impl.*;
import com.freemud.application.sdk.api.ordercenter.entities.v1.OrderBeanV1;
import com.freemud.application.sdk.api.ordercenter.enums.BizTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 根据渠道获取渠道操作实体类
 */
@Service
public class OrderBeanFactory {

    @Value("${mccafe.partner.id}")
    private String macCafePartnerId;

    @Value("#{'${o2o.orderClient}'.split(',')}")
    private List<String> o2oOrderClients;

    @Value("#{'${mall.orderClient}'.split(',')}")
    private List<String> mallOrderClients;

    @Autowired
    private ApplicationContext applicationContext;

    public OrderManagerService getOrderManagerService(OrderBeanV1 orderBean){
//        String source = orderBean.getSource();
        String orderClient = orderBean.getOrderClient();
        String companyId = orderBean.getCompanyId();
//        if (macCafePartnerId.equals(companyId)){
//            return  applicationContext.getBean(McCafeMangerServiceImpl.class);
//        }
//        if (OrderSource.BDWM.getSource().equals(source) || OrderSource.JDWM.getSource().equals(source)
//                || OrderSource.MTWM.getSource().equals(source) || OrderSource.ELEME.getSource().equals(source)
//                || OrderSource.FMWD.getSource().equals(source) || OrderSource.EBAI.getSource().equals(source)
//                || OrderSource.KOUBEI.getSource().equals(source) || OrderSource.DPZHCT.getSource().equals(source)){
//            return applicationContext.getBean(WaimaiOrderMangerServiceImpl.class);
//        }
        if (o2oOrderClients.contains(orderClient)){
            return applicationContext.getBean(WaimaiOrderMangerServiceImpl.class);
        }
        //微商城不能根据渠道，根据业务类型
        if(Objects.equals(BizTypeEnum.MALL.getBizType(),orderBean.getBizType())){
            return applicationContext.getBean(MallOrderMangerServiceImpl.class);
        }

        //商城不能根据渠道，根据业务类型
        if(Objects.equals(BizTypeEnum.FM_MALL.getBizType(),orderBean.getBizType())){
            return applicationContext.getBean(NewMallOrderMangerServiceImpl.class);
        }

        return applicationContext.getBean(SaasOrderMangerServiceImpl.class);
    }
}
