package cn.freemud.management.entities.dto.request.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/6/8 17:38
 * @description :
 */
@Data
public class RefundSuccessCallbackVo {

    @ApiModelProperty(value = "总金额", position = 10)
    private Integer totalAmount;

    @ApiModelProperty(value = "退款金额", position = 11)
    private Integer refundAmount;


    @ApiModelProperty(value = "应结总金额", position = 12)
    private Integer settlementTotalAmount;

    @ApiModelProperty(value = "应结退款金额", position = 13)
    private Integer settlementRefundAmount;

    @ApiModelProperty(value = "交易流水号", position = 14)
    private String tradeNo;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 退款描述
     */
    private String msg;



    @ApiModelProperty(value = "第三方交易流水", position = 15)
    private String thirdPartTradeNo;

    @ApiModelProperty(value = "退款交易流水号", position = 16)
    private String refundTradeNo;


    @ApiModelProperty(value = "第三方退款交易流水", position = 17)
    private String thirdPartRefundTradeNo;

    @ApiModelProperty(value = "格式：yyyyMMddHHmmss", position = 18)
    private String refundTime;

    @ApiModelProperty(value = "货币类型", position = 19)
    private String transCurrency;

    @ApiModelProperty(value = "退款状态: 100 退款成功 8200305 处理中, 其他都是失败", position = 20)
    private String refundStatus;

    @ApiModelProperty(value = "商户号", position = 21)
    private String partnerId;

    @ApiModelProperty(value = "业务方退款单号", position = 22)
    private String refundId;

    @ApiModelProperty(value = "业务方支付单号", position = 22)
    private String transId;

    @ApiModelProperty(value = "间联退款单号")
    private String refundEndTransId;
}
