package cn.freemud.entities.dto.calculate;

import lombok.Data;

import java.util.Date;

@Data
public class Discount {

    /**
     * 活动号
     */
    private String activityCode;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动描述
     */
    private String activityDesc;
    /**
     * 每个活动优惠总金额（单位分）
     */
    private Integer discount;
    /**
     * 优惠类型：
     * 1-整单满减
     * 11-每满减
     * 12-阶梯满减
     * 2-单品特价
     * 14-满额减配送费
     * 21-单品折扣
     * 3-优惠券
     * 5-整单满金额折
     * 51-每满金额折
     * 52-阶梯满金额折
     * 53-第M件/杯N折
     * 6-买M赠N
     * 7-满额赠券
     * 8-满N件换购
     * 81-满额换购
     * 82-阶梯满数量打折
     * 83-整单满数量打折
     */
    private Integer type;

    private Long thresholdAmount;
    private SendPointDto sendPointVo;
    private Date endTime;
    private Boolean zeroDiscount;

    private Integer integral;

    /**
     * 运费月卡入机字段
     */
    private String tenderId;
    /**
     *  1-运费券 2-运费月卡券 3-月卡券 4-万能券 5-啡常月享卡 6-通用券
     */
    private Integer extendType;
    /**
     * 购物车商品行uid
     */
    private String cartGoodsUid;

}
