/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetProductInfoDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/16 19:52
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
public class GetProductInfoDto {

    /**
     * 商户ID
     */
    private String partnerId;
    /**
     * 门店ID
     */
    private String shopId;
    /**
     * 商品ID
     */
    private List<String> productIds;
    /**
     * 商品信息类型 1 为基础信息 2 为详细信息
     */
    private Integer productInfoType;

    /**
     * 查询商品的属性（不管spu还是sku，都返回其spu对于的属性信息）
     */
    private Boolean autoFillSkuAttr = false;

    /**
     * 门店商品渠道，不传则默认为default,仅对开放了门店商品渠道信息商户使用,请慎用该参数
     */
    private String channel;
    /**
     * 加料商品
     */
    private List<ProductGroupType> additionalGroupList;

    @NoArgsConstructor
    @Data
    public static class ProductGroupType {

        //商品组ID
        private String pgid;

        //商户ID
        private String linkId;

        //商品组编号，跟groupId一样确认商品组唯一的字段
        private String groupCode;

        //扩展字段
        private String options;

        //商品组名")
        private String name;

        //商品组规则-是否必选
        private Integer must;

        //商品组规则-是否允许重复选
        private Integer allowRepeat;

        //商品组规则-选择的最小数量
        private Integer minNumber;

        //商品组规则-选择的最大数量
        private Integer maxNumber;

        //商品组备注
        private String remark;

        //商品组下子商品总数量
        private Integer total;


        /**
         * 商品组详情
         */
        private List<GroupDetailType> groupDetail;

        @NoArgsConstructor
        @Data
        public static class GroupDetailType {
            /**
             * 商品ID
             */
            private String productId;

            /**
             * 商品名称
             */
            private String productName;

            /**
             * 第三方商品编码
             */
            private String customerCode;

            /**
             * 标准售价
             */
            private Integer productPrice;

            /**
             * 最终售价
             */
            protected Integer productFinalPrice;

            /**
             * 最终售价
             */
            protected Integer markUpPrice;

            /**
             * 是否设置库存
             */
            private Integer stockLimit;

            /**
             * 商品Code
             */
            protected String productCode;
        }
    }
}
