package cn.freemud.service.thirdparty;


import cn.freemud.annotations.LogIgnoreFeign;
import cn.freemud.entities.dto.QueryInvoiceRepDto;
import cn.freemud.entities.vo.QueryInvoiceReq;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "ORDER-SERVICE")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface OrderClient {

    /**
     * 2021年9月15日-开票历史列表接口+详情接口+发票所含订单接口-黄兆良
     * 开票历史列表接口
     */
    @PostMapping(value = "/order/v2/invoice/list/forUser")
    @LogIgnoreFeign(logMessage="queryInvoiceList")
    QueryInvoiceRepDto queryInvoiceList(@RequestBody QueryInvoiceReq queryInvoiceReq);

}
