package cn.freemud.enums;

import org.apache.commons.lang.StringUtils;

public enum ReceiveAddressLabelType {

    COMPANY(1, "公司"),

    HOME(2, "家"),

    SCHOOL(3, "学校"),

    OTHER(4, "其他");

    private Integer code;

    private String desc;


    ReceiveAddressLabelType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ReceiveAddressLabelType getByDesc(String desc) {
        if (StringUtils.isBlank(desc)) {
            return null;
        }
        for (ReceiveAddressLabelType type : values()) {
            if (desc.equals(type.getDesc())) {
                return type;
            }
        }
        return null;
    }

    public static ReceiveAddressLabelType getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ReceiveAddressLabelType type : values()) {
            if (code.equals(type.getCode())) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
