package cn.freemud.entities.vo;

import lombok.Data;

import java.util.List;

@Data
public class OrderRiderResponseVo {
    /**
     * 订单号
     */
    private String orderId;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 配送号
     */
    private String deliveryId;
    /**
     * 门店联系电话
     */
    private String storePhone;
    /**
     * 骑手经度
     */
    private String riderLongitude;
    /**
     * 骑手纬度
     */
    private String riderLatitude;
    /**
     * 用户经度
     */
    private String destLongitude;
    /**
     * 用户纬度
     */
    private String destLatitude;
    /**
     * 门店经度
     */
    private String shopLongitude;
    /**
     * 门店纬度
     */
    private String shopLatitude;
    /**
     * 配送状态
     */
    private Integer devlieryStatus;
    /**
     * 距离
     */
    private Integer distance;

    /**
     * 骑手与收货人之间骑手时间
     */
    private Integer duration;

    /**
     * 骑手与门店骑行距离
     */
    private Long storeDistance;

    /**
     * 骑手与门店之间骑手时间
     */
    private Integer storeDuration;

    /**
     * 操作日志
     */
    private List<Operation> operationList;

    /**
     * 骑手姓名
     */
    private String riderName;

    /**
     * 骑手电话
     */
    private String riderPhone;

    /**
     * 配送类型     SELF("self", "自配送"),
     *              THIRD("third", "第三方配送");
     */
    private String deliveryType;


    @Data
    public static class Operation{
        private String createTime;
        private String operationDesc;
        private String operationMethod;
        private String operator;
    }
}
