package com.freemud.sdk.api.assortment.order.entities;

import lombok.Data;

/**
 * @author Clover.z
 * @Date 2021/10/19
 * @Desc 订单退款配置
 */
@Data
public class OrderRefundConfigEntity {

    /**
     * 未接单状态是否允许退款:
     *  0-不允许
     *  1-允许
     */
    private String takeOrderRefund;

    /**
     * 已接单状态是否允许退款:
     *  0-不允许
     *  1-允许
     */
    private String receiptOrderRefund;

    /**
     * 制作完成是否支持退款
     * 0-不允许
     * 1-允许
     */
    private String completeMakeOrderRefund;

    /**
     * 已完成订单是否允许退款
     * 0-不允许
     * 1-允许
     */
    private String orderRefund;

    /**
     * 外卖单未接单是否支持退款
     *  0-不允许
     *  1-允许
     */
    private String deliveryTakeOrderRefund;

    /**
     * 外卖单已接单是否支持退款
     *  0-不允许
     *  1-允许
     */
    private String deliveryReceiptOrderRefund;

    /**
     * 外卖单制作完成是否支持退款
     *  0-不允许
     *  1-允许
     */
    private String deliveryCompleteMakeOrderRefund;

    /**
     * 外卖单订单完成是否支持退款
     *  0-不允许
     *  1-允许
     */
    private String deliveryOrderRefund;

    /**
     * 退款允许日期
     */
    private String refundDateRange;

    /**
     * 商家同意退款时是否退配送费
     *  0-不允许
     *  1-允许
     */
    private String refundShippingFee;

    /**
     * 退款退优惠券
     *  0-不允许
     *  1-允许
     */
    private String refundReverseCoupon;

    /**
     * 收银订单是否允许退款
     * 0-不允许
     * 1-允许
     */
    private String cashierOrderRefund;
}
