package cn.freemud.demo.adapter.service;

import cn.freemud.demo.entities.ListCartGoodsRequestDTO;
import cn.freemud.demo.entities.ManagerServiceBO;
import cn.freemud.demo.entities.UpdateGoodsQtyRequestDTO;
import cn.freemud.demo.entities.bo.goods.list.ListCartGoodsBO;
import cn.freemud.demo.entities.bo.goods.list.PlatformListCartGoodsBO;
import cn.freemud.demo.entities.bo.goods.update.PlatformUpdateAddGoodsBO;
import cn.freemud.demo.entities.bo.goods.update.UpdateAddGoodsBO;
import cn.freemud.demo.enums.BizTypeEnum;
import cn.freemud.demo.manager.coupon.CouponService;
import cn.freemud.demo.manager.customer.CustomerService;
import cn.freemud.demo.manager.product.ProductService;
import cn.freemud.demo.manager.promotion.PromotionService;
import cn.freemud.demo.manager.store.StoreService;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class ListCartGoodsBOAdapter {

    @Autowired
    @Qualifier("KgdCustomerService")
    private CustomerService kgdCustomerServIce;

    @Autowired
    @Qualifier("KgdProductService")
    private ProductService kgdProductService;

    @Autowired
    @Qualifier("KgdStoreService")
    private StoreService kgdStoreService;

    @Autowired
    @Qualifier("KgdPromotionService")
    private PromotionService kgdPromotionService;

    @Autowired
    @Qualifier("KgdCouponService")
    private CouponService kgdCouponService;

    @Resource
    private MapperFacade mapperFacade;

    public ListCartGoodsBO convert2ListCartGoodsBO(String bizType, ListCartGoodsRequestDTO baseRequestDTO) {

        ListCartGoodsBO updateAddGoodsBO;
        if (BizTypeEnum.MCOFFEE.getCode().equals(bizType)) {
            updateAddGoodsBO = createMCoffeeBO(baseRequestDTO);
        } else {
            updateAddGoodsBO = createPlatformBO(baseRequestDTO);
        }
        return updateAddGoodsBO;

    }

    private ListCartGoodsBO createPlatformBO(ListCartGoodsRequestDTO baseRequestDTO) {


        PlatformListCartGoodsBO platformListCartGoodsBO = mapperFacade.map(baseRequestDTO, PlatformListCartGoodsBO.class);
        // CartGoods platformProductBO = convert2PlatformProductBO(baseRequestDTO);
        // platformAddGoodsBO.setAddGoods(platformProductBO);

        ManagerServiceBO managerService = ManagerServiceBO.builder()
                .customerService(kgdCustomerServIce)
                .productService(kgdProductService)
                .couponService(kgdCouponService)
                .storeService(kgdStoreService)
                .promotionService(kgdPromotionService)
                .build();
        platformListCartGoodsBO.setManagerService(managerService);

        return platformListCartGoodsBO;

    }

    private ListCartGoodsBO createMCoffeeBO(ListCartGoodsRequestDTO baseRequestDTO) {
        return null;
    }

}
